/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.vaadin.data.Property;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.ui.UIHelper;

class EditControls<T extends Component>
extends HorizontalLayout
implements Property.ReadOnlyStatusChangeListener,
Button.ClickListener {
    public final Button cancel;
    public final Button save;
    public final Button edit;
    private final Map<Button, List<Callback<?>>> hooks = new HashMap();
    private ButtonHandler<T> buttonHandler;

    protected EditControls(Form outerForm) {
        this((Property.ReadOnlyStatusChangeNotifier)outerForm, new FormButtonHandler<Form>(outerForm));
    }

    protected EditControls(Table outerTable) {
        this((Property.ReadOnlyStatusChangeNotifier)outerTable, new TableButtonHandler<Table>(outerTable));
    }

    protected EditControls(Property.ReadOnlyStatusChangeNotifier callback, ButtonHandler<T> buttonHandler) {
        this.buttonHandler = buttonHandler;
        callback.addListener((Property.ReadOnlyStatusChangeListener)this);
        this.save = UIHelper.createButton("save", "crystal_project/button_save.png");
        this.cancel = UIHelper.createButton("cancel", "crystal_project/button_cancel.png");
        this.edit = UIHelper.createButton("edit", "crystal_project/button_edit.png");
        this.addComponent((Component)this.edit);
        this.addComponent((Component)this.save);
        this.addComponent((Component)this.cancel);
        this.initFooterButtonActions();
        this.initHooks();
        this.setSpacing(true);
        this.setStyleName("editlayout");
    }

    private void initHooks() {
        this.hooks.put(this.cancel, new ArrayList());
        this.hooks.put(this.save, new ArrayList());
        this.hooks.put(this.edit, new ArrayList());
    }

    private void initFooterButtonActions() {
        this.edit.addListener((Button.ClickListener)this);
        this.save.addListener((Button.ClickListener)this);
        this.cancel.addListener((Button.ClickListener)this);
    }

    private void updateVisibility(boolean readOnly) {
        this.edit.setVisible(readOnly);
        this.cancel.setVisible(!readOnly);
        this.save.setVisible(!readOnly);
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.save) {
            this.buttonHandler.handleSave();
        }
        if (source == this.cancel) {
            this.buttonHandler.handleCancel();
        }
        if (source == this.edit) {
            this.buttonHandler.handleEdit();
        }
        this.executeHooks(event);
    }

    private void addHook(ButtonType button, Callback callback) {
        Button b = this.getButton(button);
        if (this.hooks.get(b) == null) {
            return;
        }
        this.hooks.get(b).add(callback);
    }

    public void addSaveHook(Callback<?> callback) {
        this.addHook(ButtonType.save, callback);
    }

    public void addEditHook(Callback<?> callback) {
        this.addHook(ButtonType.edit, callback);
    }

    public void addCancelHook(Callback<?> callback) {
        this.addHook(ButtonType.cancel, callback);
    }

    public void readOnlyStatusChange(Property.ReadOnlyStatusChangeEvent event) {
        this.updateVisibility(event.getProperty().isReadOnly());
    }

    private void executeHooks(Button.ClickEvent event) {
        if (this.hooks.get(event.getButton()) == null) {
            return;
        }
        for (Callback<?> callback : this.hooks.get(event.getButton())) {
            callback.callback(this.getButtonType(event.getButton()), this.buttonHandler.getOuter());
        }
    }

    private Button getButton(ButtonType button) {
        switch (button) {
            default: {
                return this.edit;
            }
            case cancel: {
                return this.cancel;
            }
            case save: 
        }
        return this.save;
    }

    private ButtonType getButtonType(Button button) {
        if (button == this.cancel) {
            return ButtonType.cancel;
        }
        if (button == this.save) {
            return ButtonType.save;
        }
        if (button == this.edit) {
            return ButtonType.edit;
        }
        return ButtonType.cancel;
    }

    protected EditControls<T> changeButtonHandler(ButtonHandler<T> editHandler) {
        this.buttonHandler = editHandler;
        return this;
    }

    public static class TableButtonHandler<T extends Table>
    extends FormButtonHandler<T> {
        public TableButtonHandler(T t) {
            super(t);
        }

        @Override
        protected void setEditAllowed(boolean editAllowed) {
            ((Table)this.getOuter()).setReadOnly(!editAllowed);
            ((Table)this.getOuter()).setEditable(editAllowed);
        }
    }

    public static class FormButtonHandler<T extends AbstractField>
    extends AbstractButtonHandler<T> {
        public FormButtonHandler(T outer) {
            super(outer);
        }

        @Override
        public void handleSave() {
            if (!((AbstractField)this.getOuter()).isValid()) {
                return;
            }
            ((AbstractField)this.getOuter()).commit();
            this.setEditAllowed(false);
        }

        @Override
        public void handleCancel() {
            ((AbstractField)this.getOuter()).discard();
            this.setEditAllowed(false);
        }

        @Override
        public void handleEdit() {
            this.setEditAllowed(true);
        }

        protected void setEditAllowed(boolean editAllowed) {
            ((AbstractField)this.getOuter()).setReadOnly(!editAllowed);
        }
    }

    public static abstract class AbstractButtonHandler<T extends Component>
    implements ButtonHandler<T> {
        private final T outer;

        public AbstractButtonHandler(T outer) {
            this.outer = outer;
        }

        @Override
        public T getOuter() {
            return this.outer;
        }
    }

    public static enum ButtonType {
        edit,
        cancel,
        save;

    }

    public static interface ButtonHandler<T extends Component> {
        public void handleSave();

        public void handleCancel();

        public void handleEdit();

        public T getOuter();
    }

    public static interface Callback<T extends Component> {
        public void callback(ButtonType var1, T var2);
    }
}

