/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui;

import java.util.Arrays;

public enum UiState {
    IntroductionView("Introduction", true),
    ServiceConfigurationView("Service Configuration", true),
    MbeansDetection("Determine MBeans information", false),
    MbeansView("MBeans Configuration", true),
    ResultConfigGeneration("Generate OpenNMS Configuration snippets", false),
    ResultView("OpenNMS Configuration", true);

    private final String description;
    private boolean ui;

    private UiState(String description, boolean ui) {
        this.description = description;
        this.ui = ui;
    }

    boolean hasUi() {
        return this.ui;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasPrevious() {
        return !this.isFirst();
    }

    public boolean hasNext() {
        return !this.isLast();
    }

    private boolean isFirst() {
        return UiState.values()[0].equals((Object)this);
    }

    private boolean isLast() {
        return UiState.values()[UiState.values().length - 1].equals((Object)this);
    }

    public UiState getPrevious() {
        if (this.hasPrevious()) {
            int currentIndex = Arrays.asList(UiState.values()).indexOf((Object)this);
            return UiState.values()[currentIndex - 1];
        }
        return null;
    }

    public UiState getNext() {
        if (this.hasNext()) {
            int currentIndex = Arrays.asList(UiState.values()).indexOf((Object)this);
            return UiState.values()[currentIndex + 1];
        }
        return null;
    }
}

