/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.cache;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.ticketer.jira.cache.RefreshPolicy;

public class TimeoutRefreshPolicy
implements RefreshPolicy {
    private final long refreshInterval;
    private final TimeUnit unit;
    private long lastRefreshed = -1L;

    public TimeoutRefreshPolicy(long refreshInterval, TimeUnit unit) {
        this.refreshInterval = refreshInterval;
        this.unit = Objects.requireNonNull(unit);
    }

    @Override
    public boolean needsRefresh() {
        boolean refresh;
        boolean bl = refresh = this.lastRefreshed == -1L || this.lastRefreshed + TimeUnit.MILLISECONDS.convert(this.refreshInterval, this.unit) <= System.currentTimeMillis();
        if (refresh) {
            this.lastRefreshed = System.currentTimeMillis();
        }
        return refresh;
    }
}

