/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.cache;

import java.util.Objects;
import org.opennms.netmgt.ticketer.jira.cache.CacheSupplier;
import org.opennms.netmgt.ticketer.jira.cache.RefreshPolicy;

public class Cache<V> {
    private final CacheSupplier<V> cacheSupplier;
    private final RefreshPolicy refreshPolicy;
    private V currentCache = null;

    public Cache(CacheSupplier<V> cacheSupplier, RefreshPolicy refreshPolicy) {
        this.cacheSupplier = Objects.requireNonNull(cacheSupplier);
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy);
    }

    public synchronized V get() throws Exception {
        if (this.currentCache == null || this.refreshPolicy.needsRefresh()) {
            this.currentCache = this.cacheSupplier.get();
        }
        return this.currentCache;
    }
}

