/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.domain.FieldSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.opennms.netmgt.ticketer.jira.fieldmapper.CascadingSelectFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.ComponentFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.DefaultFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.FieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.GroupFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.IssueTypeFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.LabelsFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.MultiSelectFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.NumberFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.PriorityFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.ProjectFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.SingleSelectFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.StringFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.UserFieldMapper;
import org.opennms.netmgt.ticketer.jira.fieldmapper.VersionFieldMapper;

public class FieldMapperRegistry {
    private final List<FieldMapper> fieldMapperList = new ArrayList<FieldMapper>();
    private final Map<String, String> alternativeOptionKeyLookupMap;

    public FieldMapperRegistry(Properties properties) {
        Objects.requireNonNull(properties);
        this.alternativeOptionKeyLookupMap = FieldMapperRegistry.buildLookupMap(properties);
        Supplier<Map<String, String>> lookupMapSupplier = () -> this.alternativeOptionKeyLookupMap;
        this.fieldMapperList.add(new CascadingSelectFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new ComponentFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new GroupFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new IssueTypeFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new LabelsFieldMapper());
        this.fieldMapperList.add(new MultiSelectFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new NumberFieldMapper());
        this.fieldMapperList.add(new PriorityFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new ProjectFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new SingleSelectFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new StringFieldMapper());
        this.fieldMapperList.add(new UserFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new VersionFieldMapper(lookupMapSupplier));
        this.fieldMapperList.add(new DefaultFieldMapper());
    }

    protected static Map<String, String> buildLookupMap(Properties properties) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        for (String eachKey : properties.stringPropertyNames()) {
            if (eachKey.length() <= "jira.attributes.resolution".length() || !eachKey.startsWith("jira.attributes.") || !eachKey.endsWith("resolution")) continue;
            lookupMap.put(eachKey.substring("jira.attributes.".length(), eachKey.length() - "resolution".length() - 1), properties.getProperty(eachKey));
        }
        return lookupMap;
    }

    public FieldMapper lookup(FieldSchema schema) {
        Optional<FieldMapper> firstMapper = this.fieldMapperList.stream().filter(f -> f.matches(schema)).findFirst();
        return firstMapper.get();
    }
}

