/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicProject;
import com.atlassian.jira.rest.client.api.domain.Project;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="jira", name="list-projects", description="Uses the JIRA ReST API to determine all existing projects")
@org.apache.karaf.shell.commands.Command(scope="jira", name="list-projects", description="Uses the JIRA ReST API to determine all existing projects")
@Service
public class ListProjectsCommand
extends AbstractJiraCommand
implements Action {
    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        Iterable basicProjects = (Iterable)jiraRestClient.getProjectClient().getAllProjects().get();
        if (!basicProjects.iterator().hasNext()) {
            System.out.println("No projects available or visible to the current user");
        } else {
            System.out.println(String.format("%-10.10s %-30.30s %-100.100s", "Key", "Name", "Description"));
            for (BasicProject eachProject : basicProjects) {
                String description = ((Project)jiraRestClient.getProjectClient().getProject(eachProject.getKey()).get()).getDescription();
                System.out.println(String.format("%-10.10s %-30.30s %-100.100s", eachProject.getKey(), eachProject.getName(), description == null ? "" : ListProjectsCommand.removeNewLines(description)));
            }
        }
    }
}

