/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.opennms.api.integration.ticketing.PluginException;

public class JiraConnectionFactory {
    public static JiraRestClient createConnection(String url, String username, String password) throws PluginException {
        try {
            URI jiraUri = new URL(url).toURI();
            if (Strings.isNullOrEmpty((String)username)) {
                return new AsynchronousJiraRestClientFactory().create(jiraUri, (AuthenticationHandler)new AnonymousAuthenticationHandler());
            }
            return new AsynchronousJiraRestClientFactory().createWithBasicHttpAuthentication(jiraUri, username, password);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new PluginException("Failed to parse URL: " + url);
        }
    }
}

