/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Comparator;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.ticketer.jira.JiraClientUtils;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="jira", name="list-issue-types", description="Uses the JIRA ReST API to list all issue types")
@org.apache.karaf.shell.commands.Command(scope="jira", name="list-issue-types", description="Uses the JIRA ReST API to list all issue types")
@Service
public class ListIssueTypesCommand
extends AbstractJiraCommand
implements Action {
    @Option(name="-k", aliases={"--project-key"}, description="The project to limit the issue types for. If defined it overwrites the default defined in the jira ticketing plugin configuration.")
    String projectKey;

    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        String theProjectKey = Strings.isNullOrEmpty((String)this.projectKey) ? this.getConfig().getProjectKey() : this.projectKey;
        Iterable<? extends IssueType> issueTypes = JiraClientUtils.getIssueTypes(jiraRestClient, theProjectKey);
        if (!issueTypes.iterator().hasNext()) {
            if (Strings.isNullOrEmpty((String)theProjectKey)) {
                System.out.println("No issue types found. The user making the ReST call may not have sufficient permissions.");
            } else {
                System.out.println("No issue types found for project with key '" + theProjectKey + "' found. The user making the ReST call may not have sufficient permissions.");
            }
        } else {
            System.out.println(String.format("%-10.10s %-30.30s %-100.100s", "Id", "Name", "Description"));
            Lists.newArrayList(issueTypes).stream().sorted(Comparator.comparing(IssueType::getId)).forEach(issueType -> System.out.println(String.format("%-10.10s %-30.30s %-100.100s", issueType.getId(), issueType.getName(), ListIssueTypesCommand.removeNewLines(issueType.getDescription()))));
        }
    }
}

