/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicComponent;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.google.common.base.Strings;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="jira", name="list-components", description="Uses the JIRA ReST API to list all components")
@org.apache.karaf.shell.commands.Command(scope="jira", name="list-components", description="Uses the JIRA ReST API to list all components")
@Service
public class ListComponentsCommand
extends AbstractJiraCommand
implements Action {
    @Option(name="-k", aliases={"--project-key"}, description="A project key to limit the components to. If defined it overwrites the one defined in the jira ticketer plugin configuration", required=true)
    String projectKey;

    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        String theProjectKey = Strings.isNullOrEmpty((String)this.projectKey) ? this.getConfig().getProjectKey() : this.projectKey;
        Iterable components = ((Project)jiraRestClient.getProjectClient().getProject(theProjectKey).get()).getComponents();
        if (!components.iterator().hasNext()) {
            System.out.println("No components found for project '" + theProjectKey + "'");
            return;
        }
        System.out.println(String.format("%-10.10s %-30.30s %-100.100s", "Id", "Name", "Description"));
        for (BasicComponent eachComponent : components) {
            System.out.println(String.format("%-10.10s %-30.30s %-100.100s", eachComponent.getId(), eachComponent.getName(), eachComponent.getDescription() == null ? "" : ListComponentsCommand.removeNewLines(eachComponent.getDescription())));
        }
    }
}

