/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Priority;
import org.apache.felix.gogo.commands.Command;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="jira", name="list-priorities", description="Uses the JIRA ReST API to list all priorities")
public class ListPrioritiesCommand
extends AbstractJiraCommand {
    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        Iterable priorities = (Iterable)jiraRestClient.getMetadataClient().getPriorities().get();
        if (!priorities.iterator().hasNext()) {
            System.out.println("No priorities found");
            return;
        }
        System.out.println(String.format("%-10.10s %-30.30s %-100.100s", "Id", "Name", "Description"));
        for (Priority eachPriority : priorities) {
            System.out.println(String.format("%-10.10s %-30.30s %-100.100s", eachPriority.getId(), eachPriority.getName(), ListPrioritiesCommand.removeNewLines(eachPriority.getDescription())));
        }
    }
}

