/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Project;
import com.atlassian.jira.rest.client.api.domain.Version;
import com.google.common.base.Strings;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="jira", name="list-versions", description="Uses the JIRA ReST API to list all versions")
public class ListVersionsCommand
extends AbstractJiraCommand {
    @Option(name="-k", aliases={"--project-key"}, description="A project key to limit issue types. If defined it overwrites the default defined in the jira ticketer plugin configuration")
    String projectKey;

    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        String theProjectKey = Strings.isNullOrEmpty((String)this.projectKey) ? this.getConfig().getProjectKey() : this.projectKey;
        Iterable versions = ((Project)jiraRestClient.getProjectClient().getProject(theProjectKey).get()).getVersions();
        if (!versions.iterator().hasNext()) {
            System.out.println("No versions found for project '" + theProjectKey + "'.");
            return;
        }
        System.out.println(String.format("%-10.10s %-30.30s %-100.100s", "Id", "Name", "Description"));
        for (Version eachVersion : versions) {
            System.out.println(String.format("%-10.10s %-30.30s %-100.100s", eachVersion.getId(), eachVersion.getName(), eachVersion.getDescription() == null ? "" : ListVersionsCommand.removeNewLines(eachVersion.getDescription())));
        }
    }
}

