/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;

public class Config {
    private final Properties properties;

    public Config(Properties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    public String getHost() {
        return this.getTrimmedProperty("jira.host");
    }

    public String getUsername() {
        return this.getTrimmedProperty("jira.username");
    }

    public String getPassword() {
        return this.properties.getProperty("jira.password");
    }

    public Long getIssueTypeId() throws NumberFormatException {
        String trimmedProperty = this.getTrimmedProperty("jira.type");
        try {
            return Long.valueOf(trimmedProperty);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("The value '" + trimmedProperty + "' for property 'jira.type' is not a valid number.");
        }
    }

    public String getProjectKey() {
        return this.getTrimmedProperty("jira.project");
    }

    public String getResolveTransitionName() {
        return this.getTrimmedProperty("jira.resolve");
    }

    public String getReopentransitionName() {
        return this.getTrimmedProperty("jira.reopen");
    }

    public Long getCacheReloadTime() throws NumberFormatException {
        String value = this.getTrimmedProperty("jira.cache.reloadTime");
        if (!Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)value.trim())) {
            return Long.valueOf(value.trim());
        }
        return null;
    }

    public List<String> getOpenStatus() {
        return Config.buildList(this.getTrimmedProperty("jira.status.open"));
    }

    public List<String> getCloseStatus() {
        return Config.buildList(this.getTrimmedProperty("jira.status.closed"));
    }

    public List<String> getCancelStatus() {
        return Config.buildList(this.getTrimmedProperty("jira.status.cancelled"));
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getTrimmedProperty(String key) {
        String property = this.properties.getProperty(key);
        if (property != null) {
            return property.trim();
        }
        return null;
    }

    public void validateRequiredProperties() {
        ArrayList optional = Lists.newArrayList((Object[])new String[]{"jira.username", "jira.password"});
        for (String eachKey : this.properties.stringPropertyNames()) {
            if (optional.contains(eachKey) || !Strings.isNullOrEmpty((String)this.properties.getProperty(eachKey))) continue;
            throw new RuntimeException("Property '" + eachKey + "' is required, but was null or empty");
        }
    }

    private static List<String> buildList(String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            return Arrays.stream(input.split(",")).map(v -> v.trim()).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

