/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.fieldmapper;

import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.netmgt.ticketer.jira.fieldmapper.FieldMapper;

public abstract class AbstractModifyableOptionKeyFieldMapper
implements FieldMapper {
    private final Supplier<Map<String, String>> optionKeySupplier;

    protected AbstractModifyableOptionKeyFieldMapper(Supplier<Map<String, String>> optionKeySupplier) {
        this.optionKeySupplier = Objects.requireNonNull(optionKeySupplier);
    }

    public ComplexIssueInputFieldValue createComplexIssueInputField(String fieldId, String defaultKey, Object value) {
        Objects.requireNonNull(defaultKey);
        return ComplexIssueInputFieldValue.with((String)this.getOptionKey(fieldId, defaultKey), (Object)value);
    }

    public String getOptionKey(String fieldId, String defaultKey) {
        if (fieldId != null) {
            Map<String, String> lookupMap = this.optionKeySupplier.get();
            if (this.optionKeySupplier != null && lookupMap.get(fieldId) != null && !lookupMap.isEmpty()) {
                return lookupMap.get(fieldId);
            }
        }
        return defaultKey;
    }
}

