/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.ticketer.jira.Config;
import org.opennms.netmgt.ticketer.jira.FieldMapperRegistry;
import org.opennms.netmgt.ticketer.jira.JiraClientUtils;
import org.opennms.netmgt.ticketer.jira.JiraConnectionFactory;
import org.opennms.netmgt.ticketer.jira.cache.Cache;
import org.opennms.netmgt.ticketer.jira.cache.TimeoutRefreshPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(JiraTicketerPlugin.class);
    private final Cache<List<CimProject>> fieldInfoCache;
    private final LoadingCache<CimFieldInfo, Function<String, ?>> fieldMapFunctionCache;

    public JiraTicketerPlugin() {
        Long cacheReloadTime = JiraTicketerPlugin.getConfig().getCacheReloadTime();
        if (cacheReloadTime == null || cacheReloadTime < 0L) {
            LOG.warn("Cache Reload time was set to {} ms. Negative or null values are not supported. Setting to 5 minutes.", (Object)cacheReloadTime);
            cacheReloadTime = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        }
        this.fieldMapFunctionCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(cacheReloadTime.longValue(), TimeUnit.MILLISECONDS).build(new CacheLoader<CimFieldInfo, Function<String, ?>>(){

            public Function<String, ?> load(CimFieldInfo key) throws Exception {
                return new FieldMapperRegistry(JiraTicketerPlugin.getConfig().getProperties()).lookup(key.getSchema().getType(), key.getSchema().getItems());
            }
        });
        this.fieldInfoCache = new Cache<List>(() -> JiraClientUtils.getIssueMetaData(this.getConnection(), "projects.issuetypes.fields", JiraTicketerPlugin.getConfig().getIssueTypeId(), JiraTicketerPlugin.getConfig().getProjectKey()), new TimeoutRefreshPolicy(cacheReloadTime, TimeUnit.NANOSECONDS));
    }

    protected JiraRestClient getConnection() throws PluginException {
        Config config = JiraTicketerPlugin.getConfig();
        return JiraConnectionFactory.createConnection(config.getHost(), config.getUsername(), config.getPassword());
    }

    public Ticket get(String ticketId) throws PluginException {
        Issue issue;
        JiraRestClient jira = this.getConnection();
        try {
            issue = (Issue)jira.getIssueClient().getIssue(ticketId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PluginException("Failed to get issue with id: " + ticketId, (Throwable)e);
        }
        if (issue != null) {
            Ticket ticket = new Ticket();
            ticket.setId(issue.getKey());
            ticket.setModificationTimestamp(String.valueOf(issue.getUpdateDate().toDate().getTime()));
            ticket.setSummary(issue.getSummary());
            ticket.setDetails(issue.getDescription());
            ticket.setState(JiraTicketerPlugin.getStateFromStatusName(issue.getStatus().getName()));
            return ticket;
        }
        return null;
    }

    private static Ticket.State getStateFromStatusName(String ticketStatusName) {
        HashMap<Ticket.State, List<String>> ticketStateToJiraStatusMap = new HashMap<Ticket.State, List<String>>();
        ticketStateToJiraStatusMap.put(Ticket.State.OPEN, JiraTicketerPlugin.getConfig().getOpenStatus());
        ticketStateToJiraStatusMap.put(Ticket.State.CLOSED, JiraTicketerPlugin.getConfig().getCloseStatus());
        ticketStateToJiraStatusMap.put(Ticket.State.CANCELLED, JiraTicketerPlugin.getConfig().getCancelStatus());
        for (Map.Entry entry : ticketStateToJiraStatusMap.entrySet()) {
            HashSet knownStateIds = Sets.newHashSet((Iterable)((Iterable)entry.getValue()));
            if (!knownStateIds.contains(ticketStatusName)) continue;
            return (Ticket.State)entry.getKey();
        }
        return Ticket.State.OPEN;
    }

    public static Config getConfig() {
        return new Config(JiraTicketerPlugin.getProperties());
    }

    private static Properties getProperties() {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "jira.properties");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(config);){
            props.load(in);
        }
        catch (IOException e) {
            LOG.error("Unable to load {} ignoring.", (Object)config, (Object)e);
        }
        LOG.debug("Loaded user: {}", (Object)props.getProperty("jira.username"));
        LOG.debug("Loaded type: {}", (Object)props.getProperty("jira.type"));
        return props;
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        JiraRestClient jira = this.getConnection();
        Config config = JiraTicketerPlugin.getConfig();
        if (ticket.getId() == null || ticket.getId().equals("")) {
            BasicIssue createdIssue;
            IssueInputBuilder builder = new IssueInputBuilder(config.getProjectKey(), config.getIssueTypeId());
            builder.setReporterName(config.getUsername());
            builder.setSummary(ticket.getSummary());
            builder.setDescription(ticket.getDetails());
            this.populateFields(ticket, builder);
            try {
                createdIssue = (BasicIssue)jira.getIssueClient().createIssue(builder.build()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to create issue.", (Throwable)e);
            }
            LOG.info("created ticket " + createdIssue);
            ticket.setId(createdIssue.getKey());
        } else {
            Iterable transitions;
            Issue issue;
            LOG.info("Received ticket: {}", (Object)ticket.getId());
            try {
                issue = (Issue)jira.getIssueClient().getIssue(ticket.getId()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get issue with id:" + ticket.getId(), (Throwable)e);
            }
            try {
                transitions = (Iterable)jira.getIssueClient().getTransitions(issue).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get transitions for issue with id:" + issue.getId(), (Throwable)e);
            }
            if (Ticket.State.CLOSED.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue resolved by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!config.getResolveTransitionName().equals(transition.getName())) continue;
                    LOG.info("Resolving ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to get resolve issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not resolve ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)JiraTicketerPlugin.getConfig().getResolveTransitionName());
            } else if (Ticket.State.OPEN.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue reopened by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!JiraTicketerPlugin.getConfig().getReopentransitionName().equals(transition.getName())) continue;
                    LOG.info("Reopening ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to reopen issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not reopen ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)JiraTicketerPlugin.getConfig().getReopentransitionName());
            }
        }
    }

    private void populateFields(Ticket ticket, IssueInputBuilder builder) {
        if (!ticket.hasAttributes()) {
            return;
        }
        try {
            ArrayList populatedFields = Lists.newArrayList();
            Collection<CimFieldInfo> fields = JiraClientUtils.getFields(this.fieldInfoCache.get());
            block2: for (Map.Entry eachEntry : ticket.getAttributes().entrySet()) {
                if (Strings.isNullOrEmpty((String)((String)eachEntry.getValue()))) continue;
                for (CimFieldInfo eachField : fields) {
                    if (!((String)eachEntry.getKey()).equals(eachField.getId())) continue;
                    String attributeValue = (String)eachEntry.getValue();
                    Object mappedFieldValue = ((Function)this.fieldMapFunctionCache.get((Object)eachField)).apply(attributeValue);
                    builder.setFieldValue(eachField.getId(), mappedFieldValue);
                    populatedFields.add(eachField.getId());
                    continue block2;
                }
            }
            if (populatedFields.size() != ticket.getAttributes().size()) {
                for (String eachKey : ticket.getAttributes().keySet()) {
                    if (populatedFields.contains(eachKey)) continue;
                    LOG.warn("Ticket attribute '{}' is defined, but was not mapped to a (custom) field in JIRA. Attribute is skipped.", (Object)eachKey);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Could not convert attributes to field values", (Throwable)ex);
        }
    }
}

