/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FieldMapperRegistry {
    private final Map<String, Function<String, ?>> functionMap = new HashMap();

    public FieldMapperRegistry(Properties properties) {
        Objects.requireNonNull(properties);
        Map<String, String> lookupMap = FieldMapperRegistry.buildLookupMap(properties);
        this.functionMap.put("number", input -> Long.valueOf(input));
        this.functionMap.put("group", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "group", "name", input));
        this.functionMap.put("user", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "user", "name", input));
        this.functionMap.put("issuetype", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "issuetype", "name", input));
        this.functionMap.put("priority", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "priority", "name", input));
        this.functionMap.put("version", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "version", "name", input));
        this.functionMap.put("component", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "component", "name", input));
        this.functionMap.put("option", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "option", "value", input));
        this.functionMap.put("project", input -> FieldMapperRegistry.createComplexInputFieldValue(lookupMap, "project", "key", input));
        this.functionMap.put("option-with-child", input -> {
            String[] split;
            if (!Strings.isNullOrEmpty((String)input) && (split = input.split(",")) != null && split.length >= 1) {
                HashMap<String, String> parentValueMap = new HashMap<String, String>();
                parentValueMap.put("value", split[0]);
                ComplexIssueInputFieldValue parentValue = new ComplexIssueInputFieldValue(parentValueMap);
                if (split.length >= 2) {
                    parentValue.getValuesMap().put("child", ComplexIssueInputFieldValue.with((String)"value", (Object)split[1]));
                }
                return parentValue;
            }
            return null;
        });
    }

    protected static ComplexIssueInputFieldValue createComplexInputFieldValue(Map<String, String> lookupMap, String lookupKey, String defaultKey, String input) {
        if (lookupMap.containsKey(lookupKey)) {
            return ComplexIssueInputFieldValue.with((String)lookupMap.get(lookupKey), (Object)input);
        }
        if (Strings.isNullOrEmpty((String)defaultKey)) {
            return ComplexIssueInputFieldValue.with((String)"name", (Object)input);
        }
        return ComplexIssueInputFieldValue.with((String)defaultKey, (Object)input);
    }

    protected static Map<String, String> buildLookupMap(Properties properties) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        for (String eachKey : properties.stringPropertyNames()) {
            if (eachKey.length() <= "jira.attributes.resolution".length() || !eachKey.startsWith("jira.attributes.") || !eachKey.endsWith("resolution")) continue;
            lookupMap.put(eachKey.substring("jira.attributes.".length(), eachKey.length() - "resolution".length() - 1), properties.getProperty(eachKey));
        }
        return lookupMap;
    }

    public Function<String, ?> lookup(String type, String variant) {
        if ("array".equals(type) && !Strings.isNullOrEmpty((String)variant)) {
            return input -> {
                Function<String, ?> function = this.lookup(variant);
                return Arrays.stream(input.split(",")).map(v -> function.apply((String)v)).collect(Collectors.toList());
            };
        }
        return this.lookup(type);
    }

    private Function<String, ?> lookup(String key) {
        Function<String, ?> function = this.functionMap.get(key);
        if (function != null) {
            return function;
        }
        return Function.identity();
    }
}

