/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(JiraTicketerPlugin.class);
    protected final JiraRestClientFactory clientFactory = new AsynchronousJiraRestClientFactory();

    protected JiraRestClient getConnection() {
        try {
            URI jiraUri = new URL(JiraTicketerPlugin.getProperties().getProperty("jira.host")).toURI();
            String username = JiraTicketerPlugin.getProperties().getProperty("jira.username");
            if (username == null || "".equals(username)) {
                return this.clientFactory.create(jiraUri, (AuthenticationHandler)new AnonymousAuthenticationHandler());
            }
            return this.clientFactory.createWithBasicHttpAuthentication(jiraUri, JiraTicketerPlugin.getProperties().getProperty("jira.username"), JiraTicketerPlugin.getProperties().getProperty("jira.password"));
        }
        catch (MalformedURLException e) {
            LOG.error("Failed to parse URL: {}", (Object)JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        catch (URISyntaxException e) {
            LOG.error("Failed to parse URI: {}", (Object)JiraTicketerPlugin.getProperties().getProperty("jira.host"));
        }
        return null;
    }

    public Ticket get(String ticketId) throws PluginException {
        Issue issue;
        JiraRestClient jira = this.getConnection();
        if (jira == null) {
            return null;
        }
        try {
            issue = (Issue)jira.getIssueClient().getIssue(ticketId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PluginException("Failed to get issue with id: " + ticketId, (Throwable)e);
        }
        if (issue != null) {
            Ticket ticket = new Ticket();
            ticket.setId(issue.getKey());
            ticket.setModificationTimestamp(String.valueOf(issue.getUpdateDate().toDate().getTime()));
            ticket.setSummary(issue.getSummary());
            ticket.setDetails(issue.getDescription());
            ticket.setState(JiraTicketerPlugin.getStateFromId(issue.getStatus().getName()));
            return ticket;
        }
        return null;
    }

    private static Ticket.State getStateFromId(String stateIdString) {
        if (stateIdString == null) {
            return Ticket.State.OPEN;
        }
        if ("Open".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("In Progress".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Reopened".equals(stateIdString)) {
            return Ticket.State.OPEN;
        }
        if ("Resolved".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        if ("Closed".equals(stateIdString)) {
            return Ticket.State.CLOSED;
        }
        return Ticket.State.OPEN;
    }

    private static Properties getProperties() {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "jira.properties");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(config);){
            props.load(in);
        }
        catch (IOException e) {
            LOG.error("Unable to load {} ignoring.", (Object)config, (Object)e);
        }
        LOG.debug("Loaded user: {}", (Object)props.getProperty("jira.username"));
        LOG.debug("Loaded type: {}", (Object)props.getProperty("jira.type"));
        return props;
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        JiraRestClient jira = this.getConnection();
        if (ticket.getId() == null || ticket.getId().equals("")) {
            BasicIssue createdIssue;
            IssueInputBuilder builder = new IssueInputBuilder(JiraTicketerPlugin.getProperties().getProperty("jira.project"), Long.valueOf(JiraTicketerPlugin.getProperties().getProperty("jira.type").trim()));
            builder.setReporterName(JiraTicketerPlugin.getProperties().getProperty("jira.username"));
            builder.setSummary(ticket.getSummary());
            builder.setDescription(ticket.getDetails());
            builder.setDueDate(new DateTime((Object)Calendar.getInstance()));
            try {
                createdIssue = (BasicIssue)jira.getIssueClient().createIssue(builder.build()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to create issue.", (Throwable)e);
            }
            LOG.info("created ticket " + createdIssue);
            ticket.setId(createdIssue.getKey());
        } else {
            Iterable transitions;
            Issue issue;
            LOG.info("Received ticket: {}", (Object)ticket.getId());
            try {
                issue = (Issue)jira.getIssueClient().getIssue(ticket.getId()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get issue with id:" + ticket.getId(), (Throwable)e);
            }
            try {
                transitions = (Iterable)jira.getIssueClient().getTransitions(issue).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get transitions for issue with id:" + issue.getId(), (Throwable)e);
            }
            if (Ticket.State.CLOSED.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue resolved by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!JiraTicketerPlugin.getProperties().getProperty("jira.resolve").equals(transition.getName())) continue;
                    LOG.info("Resolving ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to get resolve issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not resolve ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)JiraTicketerPlugin.getProperties().getProperty("jira.resolve"));
            } else if (Ticket.State.OPEN.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue reopened by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!JiraTicketerPlugin.getProperties().getProperty("jira.reopen").equals(transition.getName())) continue;
                    LOG.info("Reopening ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to reopen issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not reopen ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)JiraTicketerPlugin.getProperties().getProperty("jira.reopen"));
            }
        }
    }
}

