/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.beans.PropertyEditorSupport;
import org.springframework.binding.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConvertingPropertyEditorAdapter
extends PropertyEditorSupport {
    private ConversionService conversionService;
    private TypeDescriptor fieldType;
    private String converterId;
    private boolean canConvertToString;

    public ConvertingPropertyEditorAdapter(ConversionService conversionService, String converterId, TypeDescriptor fieldType) {
        Assert.notNull(conversionService, "A ConversionService instance is required.");
        Assert.notNull(fieldType, "The field type is required");
        this.conversionService = conversionService;
        this.fieldType = fieldType;
        this.converterId = converterId;
        this.canConvertToString = conversionService.getDelegateConversionService().canConvert(this.fieldType, TypeDescriptor.valueOf(String.class));
    }

    public String getAsText() {
        if (StringUtils.hasText(this.converterId)) {
            return (String)this.conversionService.executeConversion(this.converterId, this.getValue(), String.class);
        }
        if (this.canConvertToString) {
            return (String)this.conversionService.getDelegateConversionService().convert(this.getValue(), this.fieldType, TypeDescriptor.valueOf(String.class));
        }
        return null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(this.converterId)) {
            this.setValue(this.conversionService.executeConversion(this.converterId, text, this.fieldType.getType()));
        } else {
            this.setValue(this.conversionService.getDelegateConversionService().convert(text, TypeDescriptor.valueOf(String.class), this.fieldType));
        }
    }
}

