/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.engine.support.ActionTransitionCriteria;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

public class TransitionCriteriaChain
implements TransitionCriteria {
    private List criteriaChain = new LinkedList();

    public TransitionCriteriaChain() {
    }

    public TransitionCriteriaChain(TransitionCriteria[] criteria) {
        this.criteriaChain.addAll(Arrays.asList(criteria));
    }

    public TransitionCriteriaChain add(TransitionCriteria criteria) {
        this.criteriaChain.add(criteria);
        return this;
    }

    public boolean test(RequestContext context) {
        for (TransitionCriteria criteria : this.criteriaChain) {
            if (criteria.test(context)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringCreator(this).append("criteriaChain", this.criteriaChain).toString();
    }

    public static TransitionCriteria criteriaChainFor(Action[] actions2) {
        if (actions2 == null || actions2.length == 0) {
            return WildcardTransitionCriteria.INSTANCE;
        }
        TransitionCriteriaChain chain = new TransitionCriteriaChain();
        for (int i = 0; i < actions2.length; ++i) {
            chain.add(new ActionTransitionCriteria(actions2[i]));
        }
        return chain;
    }
}

