/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;

public class FlowExecutionImplFactory
implements FlowExecutionFactory {
    private static final Log logger = LogFactory.getLog(FlowExecutionImplFactory.class);
    private AttributeMap executionAttributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    private FlowExecutionListenerLoader executionListenerLoader = StaticFlowExecutionListenerLoader.EMPTY_INSTANCE;
    private FlowExecutionKeyFactory executionKeyFactory = new SimpleFlowExecutionKeyFactory();

    public void setExecutionAttributes(AttributeMap executionAttributes) {
        this.executionAttributes = executionAttributes;
    }

    public void setExecutionListenerLoader(FlowExecutionListenerLoader executionListenerLoader) {
        this.executionListenerLoader = executionListenerLoader;
    }

    public void setExecutionKeyFactory(FlowExecutionKeyFactory executionKeyFactory) {
        this.executionKeyFactory = executionKeyFactory;
    }

    public FlowExecution createFlowExecution(FlowDefinition flowDefinition) {
        Assert.isInstanceOf(Flow.class, flowDefinition, "FlowDefinition is of the wrong type: ");
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new execution of '" + flowDefinition.getId() + "'");
        }
        FlowExecutionImpl execution = new FlowExecutionImpl((Flow)flowDefinition);
        execution.setAttributes(this.executionAttributes);
        execution.setListeners(this.executionListenerLoader.getListeners(execution.getDefinition()));
        execution.setKeyFactory(this.executionKeyFactory);
        return execution;
    }

    public FlowExecution restoreFlowExecution(FlowExecution flowExecution, FlowDefinition flowDefinition, FlowExecutionKey flowExecutionKey, MutableAttributeMap conversationScope, FlowDefinitionLocator subflowDefinitionLocator) {
        Assert.isInstanceOf(FlowExecutionImpl.class, flowExecution, "FlowExecution is of the wrong type: ");
        Assert.isInstanceOf(Flow.class, flowDefinition, "FlowDefinition is of the wrong type: ");
        FlowExecutionImpl execution = (FlowExecutionImpl)flowExecution;
        Flow flow = (Flow)flowDefinition;
        execution.setFlow(flow);
        if (execution.hasSessions()) {
            FlowSessionImpl rootSession = execution.getRootSession();
            rootSession.setFlow(flow);
            rootSession.setState(flow.getStateInstance(rootSession.getStateId()));
            if (execution.hasSubflowSessions()) {
                Iterator it = execution.getSubflowSessionIterator();
                while (it.hasNext()) {
                    FlowSessionImpl subflowSession = (FlowSessionImpl)it.next();
                    Flow subflowDef = (Flow)subflowDefinitionLocator.getFlowDefinition(subflowSession.getFlowId());
                    subflowSession.setFlow(subflowDef);
                    subflowSession.setState(subflowDef.getStateInstance(subflowSession.getStateId()));
                }
            }
        }
        execution.setKey(flowExecutionKey);
        if (conversationScope == null) {
            conversationScope = new LocalAttributeMap();
        }
        execution.setConversationScope(conversationScope);
        execution.setAttributes(this.executionAttributes);
        execution.setListeners(this.executionListenerLoader.getListeners(execution.getDefinition()));
        execution.setKeyFactory(this.executionKeyFactory);
        return execution;
    }

    private static class SimpleFlowExecutionKeyFactory
    implements FlowExecutionKeyFactory {
        private int sequence;

        private SimpleFlowExecutionKeyFactory() {
        }

        public FlowExecutionKey getKey(FlowExecution execution) {
            if (execution.getKey() == null) {
                return new SimpleFlowExecutionKey(this.nextSequence());
            }
            return execution.getKey();
        }

        public void removeAllFlowExecutionSnapshots(FlowExecution execution) {
        }

        public void removeFlowExecutionSnapshot(FlowExecution execution) {
        }

        public void updateFlowExecutionSnapshot(FlowExecution execution) {
        }

        private synchronized int nextSequence() {
            return ++this.sequence;
        }

        private static class SimpleFlowExecutionKey
        extends FlowExecutionKey {
            private int value;

            public SimpleFlowExecutionKey(int value) {
                this.value = value;
            }

            public boolean equals(Object o) {
                if (!(o instanceof SimpleFlowExecutionKey)) {
                    SimpleFlowExecutionKey key = (SimpleFlowExecutionKey)o;
                    return this.value == key.value;
                }
                return false;
            }

            public int hashCode() {
                return this.value;
            }

            public String toString() {
                return String.valueOf(this.value);
            }
        }
    }
}

