/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import java.util.ArrayList;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CompositeAction
extends AbstractAction {
    public static final String ACTION_RESULTS_ATTRIBUTE_NAME = "actionResults";
    private Action[] actions;
    private boolean stopOnError;

    public CompositeAction(Action[] actions2) {
        Assert.notEmpty(actions2, "At least one action is required");
        this.actions = actions2;
    }

    protected Action[] getActions() {
        return this.actions;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public Event doExecute(RequestContext context) throws Exception {
        Action[] actions2 = this.getActions();
        String eventId = this.getEventFactorySupport().getSuccessEventId();
        LocalAttributeMap eventAttributes = new LocalAttributeMap();
        ArrayList<Event> actionResults = new ArrayList<Event>(actions2.length);
        for (int i = 0; i < actions2.length; ++i) {
            Event result = actions2[i].execute(context);
            actionResults.add(result);
            if (result == null) continue;
            eventId = result.getId();
            if (this.isStopOnError() && result.getId().equals(this.getEventFactorySupport().getErrorEventId())) break;
        }
        eventAttributes.put(ACTION_RESULTS_ATTRIBUTE_NAME, actionResults);
        return new Event(this, eventId, eventAttributes);
    }

    public String toString() {
        return new ToStringCreator(this).append("actions", this.getActions()).append("stopOnError", this.isStopOnError()).toString();
    }
}

