/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.util.Collection;
import java.util.Map;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.util.Assert;

public class MapAccessor
implements MapAdaptable {
    private Map map;

    public MapAccessor(Map map) {
        Assert.notNull(map, "The map to decorate is required");
        this.map = map;
    }

    public Map asMap() {
        return this.map;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object get(Object key, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.map.get(key);
    }

    public Object get(Object key, Class requiredType) throws IllegalArgumentException {
        return this.get(key, requiredType, null);
    }

    public Object get(Object key, Class requiredType, Object defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, requiredType);
    }

    public Object getRequired(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.map.get(key);
    }

    public Object getRequired(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, requiredType);
    }

    public String getString(Object key) throws IllegalArgumentException {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return (String)this.assertKeyValueOfType(key, String.class);
    }

    public String getRequiredString(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (String)this.assertKeyValueOfType(key, String.class);
    }

    public Collection getCollection(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (Collection)this.assertKeyValueOfType(key, Collection.class);
    }

    public Collection getCollection(Object key, Class requiredType) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.assertAssignableTo(Collection.class, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Collection getRequiredCollection(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Collection)this.assertKeyValueOfType(key, Collection.class);
    }

    public Collection getRequiredCollection(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(Collection.class, requiredType);
        return (Collection)this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getArray(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertAssignableTo(Object[].class, requiredType);
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Object[] getRequiredArray(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(Object[].class, requiredType);
        return (Object[])this.assertKeyValueOfType(key, requiredType);
    }

    public Number getNumber(Object key, Class requiredType) throws IllegalArgumentException {
        return this.getNumber(key, requiredType, null);
    }

    public Number getNumber(Object key, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        this.assertAssignableTo(Number.class, requiredType);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Number getRequiredNumber(Object key, Class requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Number)this.assertKeyValueOfType(key, requiredType);
    }

    public Integer getInteger(Object key) throws IllegalArgumentException {
        return this.getInteger(key, null);
    }

    public Integer getInteger(Object key, Integer defaultValue) throws IllegalArgumentException {
        return (Integer)this.getNumber(key, Integer.class, defaultValue);
    }

    public Integer getRequiredInteger(Object key) throws IllegalArgumentException {
        return (Integer)this.getRequiredNumber(key, Integer.class);
    }

    public Long getLong(Object key) throws IllegalArgumentException {
        return this.getLong(key, null);
    }

    public Long getLong(Object key, Long defaultValue) throws IllegalArgumentException {
        return (Long)this.getNumber(key, Long.class, defaultValue);
    }

    public Long getRequiredLong(Object key) throws IllegalArgumentException {
        return (Long)this.getRequiredNumber(key, Long.class);
    }

    public Boolean getBoolean(Object key) throws IllegalArgumentException {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return (Boolean)this.assertKeyValueOfType(key, Boolean.class);
    }

    public Boolean getRequiredBoolean(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (Boolean)this.assertKeyValueOfType(key, Boolean.class);
    }

    public void assertContainsKey(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Required attribute '" + key + "' is not present in map; attributes present are [" + this.asMap() + "]");
        }
    }

    public boolean containsKey(Object key, Class requiredType) throws IllegalArgumentException {
        if (this.map.containsKey(key)) {
            this.assertKeyValueOfType(key, requiredType);
            return true;
        }
        return false;
    }

    public Object assertKeyValueOfType(Object key, Class requiredType) {
        return this.assertKeyValueInstanceOf(key, this.map.get(key), requiredType);
    }

    public Object assertKeyValueInstanceOf(Object key, Object value, Class requiredType) {
        Assert.notNull(requiredType, "The required type to assert is required");
        if (value != null && !requiredType.isInstance(value)) {
            throw new IllegalArgumentException("Map key '" + key + "' has value [" + value + "] that is not of expected type [" + requiredType + "], instead it is of type [" + value.getClass().getName() + "]");
        }
        return value;
    }

    private void assertAssignableTo(Class clazz, Class requiredType) {
        Assert.isTrue(clazz.isAssignableFrom(requiredType), "The provided required type must be assignable to [" + clazz + "]");
    }
}

