/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckError;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCheck
extends AbstractConstraintCheck {
    private ConstraintHelper constraintHelper;

    public TypeCheck(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
    }

    @Override
    public Set<ConstraintCheckError> checkField(VariableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.asType(), "NOT_SUPPORTED_TYPE");
    }

    @Override
    public Set<ConstraintCheckError> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.getReturnType(), "NOT_SUPPORTED_RETURN_TYPE");
    }

    @Override
    public Set<ConstraintCheckError> checkNonAnnotationType(TypeElement element, AnnotationMirror annotation) {
        return this.checkInternal(element, annotation, element.asType(), "NOT_SUPPORTED_TYPE");
    }

    private Set<ConstraintCheckError> checkInternal(Element element, AnnotationMirror annotation, TypeMirror type, String messageKey) {
        if (this.constraintHelper.checkConstraint(annotation.getAnnotationType(), type) != ConstraintHelper.ConstraintCheckResult.ALLOWED) {
            return CollectionHelper.asSet(new ConstraintCheckError(element, annotation, messageKey, annotation.getAnnotationType().asElement().getSimpleName()));
        }
        return Collections.emptySet();
    }
}

