/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import org.springframework.binding.mapping.Mapper;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.FlowInputMappingException;
import org.springframework.webflow.engine.FlowOutputMappingException;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.execution.RequestContext;

public final class GenericSubflowAttributeMapper
implements SubflowAttributeMapper,
Serializable {
    private final Mapper inputMapper;
    private final Mapper outputMapper;

    public GenericSubflowAttributeMapper(Mapper inputMapper, Mapper outputMapper) {
        this.inputMapper = inputMapper;
        this.outputMapper = outputMapper;
    }

    public MutableAttributeMap createSubflowInput(RequestContext context) {
        if (this.inputMapper != null) {
            LocalAttributeMap input = new LocalAttributeMap();
            MappingResults results = this.inputMapper.map(context, input);
            if (results != null && results.hasErrorResults()) {
                throw new FlowInputMappingException(context.getActiveFlow().getId(), context.getCurrentState().getId(), results);
            }
            return input;
        }
        return new LocalAttributeMap();
    }

    public void mapSubflowOutput(AttributeMap output, RequestContext context) {
        MappingResults results;
        if (this.outputMapper != null && output != null && (results = this.outputMapper.map(output, context)) != null && results.hasErrorResults()) {
            throw new FlowOutputMappingException(context.getActiveFlow().getId(), context.getCurrentState().getId(), results);
        }
    }

    public String toString() {
        return new ToStringCreator(this).append("inputMapper", this.inputMapper).append("outputMapper", this.outputMapper).toString();
    }
}

