/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class EndStateModel
extends AbstractStateModel {
    private String view;
    private String commit;
    private LinkedList outputs;

    public EndStateModel(String id) {
        super(id);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof EndStateModel)) {
            return false;
        }
        EndStateModel state = (EndStateModel)model;
        return ObjectUtils.nullSafeEquals(this.getId(), state.getId());
    }

    public void merge(Model model) {
        EndStateModel state = (EndStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setView(this.merge(this.getView(), state.getView()));
        this.setCommit(this.merge(this.getCommit(), state.getCommit()));
        this.setOutputs(this.merge(this.getOutputs(), state.getOutputs(), false));
    }

    public Model createCopy() {
        EndStateModel copy = new EndStateModel(this.getId());
        super.fillCopy(copy);
        copy.setView(this.view);
        copy.setCommit(this.commit);
        copy.setOutputs(this.outputs);
        return copy;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = StringUtils.hasText(view) ? view : null;
    }

    public String getCommit() {
        return this.commit;
    }

    public void setCommit(String commit) {
        this.commit = StringUtils.hasText(commit) ? commit : null;
    }

    public LinkedList getOutputs() {
        return this.outputs;
    }

    public void setOutputs(LinkedList outputs) {
        this.outputs = outputs;
    }
}

