/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.SecuredModel;

public abstract class AbstractStateModel
extends AbstractModel {
    private String id;
    private String parent;
    private LinkedList attributes;
    private SecuredModel secured;
    private LinkedList onEntryActions;
    private LinkedList exceptionHandlers;

    public AbstractStateModel(String id) {
        this.setId(id);
    }

    protected void fillCopy(AbstractStateModel copy) {
        copy.setParent(this.parent);
        copy.setAttributes(this.copyList(this.attributes));
        copy.setSecured((SecuredModel)this.copy(this.secured));
        copy.setOnEntryActions(this.copyList(this.onEntryActions));
        copy.setExceptionHandlers(this.copyList(this.exceptionHandlers));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StringUtils.hasText(id) ? id : null;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = StringUtils.hasText(parent) ? parent : null;
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public LinkedList getOnEntryActions() {
        return this.onEntryActions;
    }

    public void setOnEntryActions(LinkedList onEntryActions) {
        this.onEntryActions = onEntryActions;
    }

    public LinkedList getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(LinkedList exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }
}

