/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.FlowExecutionException;

public class SubflowState
extends TransitionableState {
    private Expression subflow;
    private SubflowAttributeMapper subflowAttributeMapper;

    public SubflowState(Flow flow, String id, Expression subflow) throws IllegalArgumentException {
        super(flow, id);
        this.setSubflow(subflow);
    }

    private void setSubflow(Expression subflow) {
        Assert.notNull(subflow, "A subflow state must have a subflow; the subflow is required");
        this.subflow = subflow;
    }

    public void setAttributeMapper(SubflowAttributeMapper attributeMapper) {
        this.subflowAttributeMapper = attributeMapper;
    }

    protected void doEnter(RequestControlContext context) throws FlowExecutionException {
        MutableAttributeMap flowInput = this.subflowAttributeMapper != null ? this.subflowAttributeMapper.createSubflowInput(context) : new LocalAttributeMap();
        Flow subflow = (Flow)this.subflow.getValue(context);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Calling subflow '" + subflow.getId() + "' with input " + flowInput);
        }
        context.start(subflow, flowInput);
    }

    public boolean handleEvent(RequestControlContext context) {
        if (this.subflowAttributeMapper != null) {
            AttributeMap subflowOutput = context.getCurrentEvent().getAttributes();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Mapping subflow output " + subflowOutput);
            }
            this.subflowAttributeMapper.mapSubflowOutput(subflowOutput, context);
        }
        return super.handleEvent(context);
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("subflow", this.subflow).append("subflowAttributeMapper", this.subflowAttributeMapper);
        super.appendToString(creator);
    }
}

