/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.Collections;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class FlowBuilderInfo {
    private String id;
    private String className;
    private Set attributes;

    public FlowBuilderInfo(String id, String className, Set attributes) {
        Assert.hasText(className, "The fully-qualified FlowBuilder class name is required");
        this.className = className;
        this.setId(id);
        this.attributes = attributes != null ? attributes : Collections.EMPTY_SET;
    }

    private void setId(String id) {
        this.id = StringUtils.hasText(id) ? id : StringUtils.uncapitalize(StringUtils.delete(ClassUtils.getShortName(this.className), "FlowBuilder"));
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Set getAttributes() {
        return this.attributes;
    }
}

