/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

public class EhCacheFactoryBean
extends CacheConfiguration
implements FactoryBean<Ehcache>,
BeanNameAware,
InitializingBean {
    private static final boolean setStatisticsAvailable = ClassUtils.hasMethod(Ehcache.class, "setStatisticsEnabled", Boolean.TYPE);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private boolean blocking = false;
    private CacheEntryFactory cacheEntryFactory;
    private BootstrapCacheLoader bootstrapCacheLoader;
    private Set<CacheEventListener> cacheEventListeners;
    private boolean statisticsEnabled = false;
    private boolean sampledStatisticsEnabled = false;
    private boolean disabled = false;
    private String beanName;
    private Ehcache cache;

    public EhCacheFactoryBean() {
        this.setMaxElementsInMemory(10000);
        this.setMaxElementsOnDisk(10000000);
        this.setTimeToLiveSeconds(120L);
        this.setTimeToIdleSeconds(120L);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheName(String cacheName) {
        this.setName(cacheName);
    }

    public void setTimeToLive(int timeToLive) {
        this.setTimeToLiveSeconds(timeToLive);
    }

    public void setTimeToIdle(int timeToIdle) {
        this.setTimeToIdleSeconds(timeToIdle);
    }

    public void setDiskSpoolBufferSize(int diskSpoolBufferSize) {
        this.setDiskSpoolBufferSizeMB(diskSpoolBufferSize);
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setCacheEntryFactory(CacheEntryFactory cacheEntryFactory) {
        this.cacheEntryFactory = cacheEntryFactory;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) {
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setCacheEventListeners(Set<CacheEventListener> cacheEventListeners) {
        this.cacheEventListeners = cacheEventListeners;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public void setSampledStatisticsEnabled(boolean sampledStatisticsEnabled) {
        this.sampledStatisticsEnabled = sampledStatisticsEnabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterPropertiesSet() throws CacheException, IOException {
        String cacheName = this.getName();
        if (cacheName == null) {
            cacheName = this.beanName;
            this.setName(cacheName);
        }
        if (this.cacheManager == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using default EhCache CacheManager for cache region '" + cacheName + "'");
            }
            this.cacheManager = CacheManager.getInstance();
        }
        CacheManager cacheManager = this.cacheManager;
        synchronized (cacheManager) {
            Ehcache decoratedCache;
            Cache rawCache;
            boolean cacheExists = this.cacheManager.cacheExists(cacheName);
            if (cacheExists) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Using existing EhCache cache region '" + cacheName + "'");
                }
                rawCache = this.cacheManager.getEhcache(cacheName);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Creating new EhCache cache region '" + cacheName + "'");
                }
                rawCache = this.createCache();
                rawCache.setBootstrapCacheLoader(this.bootstrapCacheLoader);
            }
            if (this.cacheEventListeners != null) {
                for (CacheEventListener listener : this.cacheEventListeners) {
                    rawCache.getCacheEventNotificationService().registerListener(listener);
                }
            }
            if (!cacheExists) {
                this.cacheManager.addCache((Ehcache)rawCache);
            }
            if (setStatisticsAvailable) {
                if (this.statisticsEnabled) {
                    rawCache.setStatisticsEnabled(true);
                }
                if (this.sampledStatisticsEnabled) {
                    rawCache.setSampledStatisticsEnabled(true);
                }
            }
            if (this.disabled) {
                rawCache.setDisabled(true);
            }
            if ((decoratedCache = this.decorateCache((Ehcache)rawCache)) != rawCache) {
                this.cacheManager.replaceCacheWithDecoratedCache((Ehcache)rawCache, decoratedCache);
            }
            this.cache = decoratedCache;
        }
    }

    protected Cache createCache() {
        return new Cache((CacheConfiguration)this);
    }

    protected Ehcache decorateCache(Ehcache cache) {
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return new UpdatingSelfPopulatingCache(cache, (UpdatingCacheEntryFactory)this.cacheEntryFactory);
            }
            return new SelfPopulatingCache(cache, this.cacheEntryFactory);
        }
        if (this.blocking) {
            return new BlockingCache(cache);
        }
        return cache;
    }

    @Override
    public Ehcache getObject() {
        return this.cache;
    }

    @Override
    public Class<? extends Ehcache> getObjectType() {
        if (this.cache != null) {
            return this.cache.getClass();
        }
        if (this.cacheEntryFactory != null) {
            if (this.cacheEntryFactory instanceof UpdatingCacheEntryFactory) {
                return UpdatingSelfPopulatingCache.class;
            }
            return SelfPopulatingCache.class;
        }
        if (this.blocking) {
            return BlockingCache.class;
        }
        return Cache.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

