/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.method;

import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class MethodSignature {
    private String methodName;
    private Parameters parameters;

    public MethodSignature(String methodName) {
        this(methodName, Parameters.NONE);
    }

    public MethodSignature(String methodName, Parameter parameter) {
        this(methodName, new Parameters(parameter));
    }

    public MethodSignature(String methodName, Parameters parameters) {
        Assert.notNull(methodName, "The method name is required");
        Assert.notNull(parameters, "The parameters are required");
        this.methodName = methodName;
        this.parameters = parameters;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        return this.methodName.equals(other.methodName) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return new ToStringCreator(this).append("methodName", this.methodName).append("parameters", this.parameters).toString();
    }
}

