/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.util.Assert;

public class CompositeIterator
implements Iterator {
    private List iterators = new LinkedList();
    private boolean inUse = false;

    public void add(Iterator iterator) {
        Assert.state(!this.inUse, "You can no longer add iterator to a composite iterator that's already in use");
        if (this.iterators.contains(iterator)) {
            throw new IllegalArgumentException("You cannot add the same iterator twice");
        }
        this.iterators.add(iterator);
    }

    public boolean hasNext() {
        this.inUse = true;
        Iterator it = this.iterators.iterator();
        while (it.hasNext()) {
            if (!((Iterator)it.next()).hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        this.inUse = true;
        for (Iterator iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return iterator.next();
        }
        throw new NoSuchElementException("Exhaused all iterators");
    }

    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }
}

