/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container;

import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.spring.Autowire;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import com.sun.jersey.spi.inject.Inject;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.ClassUtils;

public class SpringComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(SpringComponentProviderFactory.class.getName());
    private final ConfigurableApplicationContext springContext;
    private final Map<String, ComponentScope> scopeMap = this.createScopeMap();

    public SpringComponentProviderFactory(ResourceConfig rc, ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
        this.addAppContextInjectableProvider(rc);
        this.registerSpringBeans(rc);
    }

    private void addAppContextInjectableProvider(ResourceConfig rc) {
        rc.getSingletons().add(new SingletonTypeInjectableProvider<Context, ApplicationContext>(ApplicationContext.class, (ApplicationContext)this.springContext){});
    }

    private void registerSpringBeans(ResourceConfig rc) {
        String[] names;
        for (String name : names = BeanFactoryUtils.beanNamesIncludingAncestors(this.springContext)) {
            Class<?> type = ClassUtils.getUserClass(this.springContext.getType(name));
            if (ResourceConfig.isProviderClass(type)) {
                LOGGER.info("Registering Spring bean, " + name + ", of type " + type.getName() + " as a provider class");
                rc.getClasses().add(type);
                continue;
            }
            if (!ResourceConfig.isRootResourceClass(type)) continue;
            LOGGER.info("Registering Spring bean, " + name + ", of type " + type.getName() + " as a root resource class");
            rc.getClasses().add(type);
        }
    }

    @Override
    public IoCComponentProvider getComponentProvider(Class c) {
        return this.getComponentProvider((ComponentContext)null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class c) {
        Autowire autowire = c.getAnnotation(Autowire.class);
        if (autowire != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Creating resource class " + c.getSimpleName() + " annotated with @" + Autowire.class.getSimpleName() + " as spring bean.");
            }
            return new SpringInstantiatedComponentProvider(c, autowire);
        }
        String beanName = SpringComponentProviderFactory.getBeanName(cc, c, this.springContext);
        if (beanName == null) {
            return null;
        }
        String scope = this.findBeanDefinition(beanName).getScope();
        return new SpringManagedComponentProvider(this.getComponentScope(scope), beanName, c);
    }

    private BeanDefinition findBeanDefinition(String beanName) {
        ConfigurableApplicationContext current = this.springContext;
        BeanDefinition beanDef = null;
        while (true) {
            try {
                return current.getBeanFactory().getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException e) {
                ApplicationContext parent = current.getParent();
                if (parent == null || !(parent instanceof ConfigurableApplicationContext)) {
                    throw e;
                }
                current = (ConfigurableApplicationContext)parent;
                if (beanDef == null && current != null) continue;
                return beanDef;
            }
            break;
        }
    }

    private ComponentScope getComponentScope(String scope) {
        ComponentScope cs = this.scopeMap.get(scope);
        return cs != null ? cs : ComponentScope.Undefined;
    }

    private Map<String, ComponentScope> createScopeMap() {
        HashMap<String, ComponentScope> m = new HashMap<String, ComponentScope>();
        m.put("singleton", ComponentScope.Singleton);
        m.put("prototype", ComponentScope.PerRequest);
        m.put("request", ComponentScope.PerRequest);
        return m;
    }

    private static Object getInjectableInstance(Object o) {
        if (AopUtils.isAopProxy(o)) {
            Advised aopResource = (Advised)o;
            try {
                return aopResource.getTargetSource().getTarget();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not get target object from proxy.", e);
                throw new RuntimeException("Could not get target object from proxy.", e);
            }
        }
        return o;
    }

    private static String getBeanName(ComponentContext cc, Class<?> c, ApplicationContext springContext) {
        String[] names;
        boolean annotatedWithInject = false;
        if (cc != null) {
            InjectParam injectParam;
            Inject inject = SpringComponentProviderFactory.getAnnotation(cc.getAnnotations(), Inject.class);
            if (inject != null) {
                annotatedWithInject = true;
                if (inject.value() != null && !inject.value().equals("")) {
                    return inject.value();
                }
            }
            if ((injectParam = SpringComponentProviderFactory.getAnnotation(cc.getAnnotations(), InjectParam.class)) != null) {
                annotatedWithInject = true;
                if (injectParam.value() != null && !injectParam.value().equals("")) {
                    return injectParam.value();
                }
            }
        }
        if ((names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(springContext, c)).length == 0) {
            return null;
        }
        if (names.length == 1) {
            return names[0];
        }
        boolean inheritedNames = false;
        String beanName = null;
        for (String name : names) {
            Class<?> beanType = ClassUtils.getUserClass(springContext.getType(name));
            inheritedNames = c.isAssignableFrom(beanType);
            if (c != beanType) continue;
            beanName = name;
        }
        if (inheritedNames && beanName != null) {
            return beanName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("There are multiple beans configured in spring for the type ").append(c.getName()).append(".");
        if (annotatedWithInject) {
            sb.append("\nYou should specify the name of the preferred bean with @InjectParam(\"name\") or @Inject(\"name\").");
        } else {
            sb.append("\nAnnotation information was not available, the reason might be because you're not using @InjectParam. You should use @InjectParam and specifiy the bean name via InjectParam(\"name\").");
        }
        sb.append("\nAvailable bean names: ").append(SpringComponentProviderFactory.toCSV(names));
        throw new RuntimeException(sb.toString());
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(clazz)) continue;
                return (T)((Annotation)clazz.cast(annotation));
            }
        }
        return null;
    }

    private static <T> String toCSV(T[] items) {
        if (items == null) {
            return null;
        }
        return SpringComponentProviderFactory.toCSV(Arrays.asList(items));
    }

    private static <I> String toCSV(Collection<I> items) {
        return SpringComponentProviderFactory.toCSV(items, ", ", null);
    }

    private static <I> String toCSV(Collection<I> items, String separator, String delimiter) {
        if (items == null) {
            return null;
        }
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<I> iter = items.iterator();
        while (iter.hasNext()) {
            if (delimiter != null) {
                sb.append(delimiter);
            }
            I item = iter.next();
            sb.append(item);
            if (delimiter != null) {
                sb.append(delimiter);
            }
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    private class SpringManagedComponentProvider
    implements IoCManagedComponentProvider {
        private final ComponentScope scope;
        private final String beanName;
        private final Class c;

        SpringManagedComponentProvider(ComponentScope scope, String beanName, Class c) {
            this.scope = scope;
            this.beanName = beanName;
            this.c = c;
        }

        @Override
        public ComponentScope getScope() {
            return this.scope;
        }

        @Override
        public Object getInjectableInstance(Object o) {
            return SpringComponentProviderFactory.getInjectableInstance(o);
        }

        @Override
        public Object getInstance() {
            return SpringComponentProviderFactory.this.springContext.getBean(this.beanName, this.c);
        }
    }

    private class SpringInstantiatedComponentProvider
    implements IoCInstantiatedComponentProvider {
        private final Class c;
        private final Autowire a;

        SpringInstantiatedComponentProvider(Class c, Autowire a) {
            this.c = c;
            this.a = a;
        }

        @Override
        public Object getInstance() {
            return SpringComponentProviderFactory.this.springContext.getBeanFactory().createBean(this.c, this.a.mode().getSpringCode(), this.a.dependencyCheck());
        }

        @Override
        public Object getInjectableInstance(Object o) {
            return SpringComponentProviderFactory.getInjectableInstance(o);
        }
    }
}

