/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.domain.input.VersionInput;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VersionInputJsonGenerator
implements JsonGenerator<VersionInput> {
    @Override
    public JSONObject generate(VersionInput version) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", version.getName());
        jsonObject.put("project", version.getProjectKey());
        if (version.getDescription() != null) {
            jsonObject.put("description", version.getDescription());
        }
        if (version.getReleaseDate() != null) {
            jsonObject.put("releaseDate", JsonParseUtil.formatDate(version.getReleaseDate()));
        }
        jsonObject.put("released", version.isReleased());
        jsonObject.put("archived", version.isArchived());
        return jsonObject;
    }
}

