/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.ProjectRole;
import com.atlassian.jira.rest.client.domain.RoleActor;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.RoleActorJsonParser;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ProjectRoleJsonParser
implements JsonObjectParser<ProjectRole> {
    private final RoleActorJsonParser roleActorJsonParser;

    public ProjectRoleJsonParser(URI baseJiraUri) {
        this.roleActorJsonParser = new RoleActorJsonParser(baseJiraUri);
    }

    @Override
    public ProjectRole parse(JSONObject json) throws JSONException {
        URI self = JsonParseUtil.getSelfUri(json);
        long id = json.getLong("id");
        String name = json.getString("name");
        String description = json.getString("description");
        Optional<JSONArray> roleActorsOpt = JsonParseUtil.getOptionalArray(json, "actors");
        ImmutableSet<RoleActor> roleActors = roleActorsOpt.isPresent() ? JsonParseUtil.parseJsonArray(roleActorsOpt.get(), this.roleActorJsonParser) : ImmutableSet.of();
        return new ProjectRole(id, self, name, description, roleActors);
    }
}

