/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.IdentifiableEntity;
import com.atlassian.jira.rest.client.domain.IssueFieldId;
import com.google.common.base.Objects;

public class FieldInput
implements IdentifiableEntity<String> {
    private final String id;
    private final Object value;

    public FieldInput(String id, Object value) {
        this.id = id;
        this.value = value;
    }

    public FieldInput(IssueFieldId field, Object value) {
        this.id = field.id;
        this.value = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldInput) {
            FieldInput other = (FieldInput)obj;
            return Objects.equal(this.id, other.id) && Objects.equal(this.value, other.value);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("id", this.id).add("value", this.value).toString();
    }
}

