/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain.input;

import com.atlassian.jira.rest.client.IdentifiableEntity;
import com.atlassian.jira.rest.client.NamedEntity;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.CustomFieldOption;
import com.atlassian.jira.rest.client.domain.TimeTracking;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.ValueTransformer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class BaseValueTransformer
implements ValueTransformer {
    @Override
    public Object apply(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof String || rawValue instanceof Number || rawValue instanceof ComplexIssueInputFieldValue) {
            return rawValue;
        }
        if (rawValue instanceof BasicProject) {
            return new ComplexIssueInputFieldValue(ImmutableMap.of("key", ((BasicProject)rawValue).getKey()));
        }
        if (rawValue instanceof CustomFieldOption) {
            return this.transformCustomFieldOption((CustomFieldOption)rawValue);
        }
        if (rawValue instanceof TimeTracking) {
            return this.transformTimeTracking((TimeTracking)rawValue);
        }
        if (rawValue instanceof IdentifiableEntity) {
            IdentifiableEntity identifiableEntity = (IdentifiableEntity)rawValue;
            return new ComplexIssueInputFieldValue(ImmutableMap.of("id", identifiableEntity.getId().toString()));
        }
        if (rawValue instanceof NamedEntity) {
            NamedEntity namedEntity = (NamedEntity)rawValue;
            return new ComplexIssueInputFieldValue(ImmutableMap.of("name", namedEntity.getName()));
        }
        return CANNOT_HANDLE;
    }

    private ComplexIssueInputFieldValue transformCustomFieldOption(CustomFieldOption cfo) {
        if (cfo.getChild() != null) {
            return new ComplexIssueInputFieldValue(ImmutableMap.of("id", cfo.getId().toString(), "value", cfo.getValue(), "child", this.apply(cfo.getChild())));
        }
        return new ComplexIssueInputFieldValue(ImmutableMap.of("id", cfo.getId().toString(), "value", cfo.getValue()));
    }

    private ComplexIssueInputFieldValue transformTimeTracking(TimeTracking timeTracking) {
        Integer remainingEstimateMinutes;
        HashMap<String, Object> fields = Maps.newHashMap();
        Integer originalEstimateMinutes = timeTracking.getOriginalEstimateMinutes();
        if (originalEstimateMinutes != null) {
            fields.put("originalEstimate", originalEstimateMinutes + "m");
        }
        if ((remainingEstimateMinutes = timeTracking.getRemainingEstimateMinutes()) != null) {
            fields.put("remainingEstimate", remainingEstimateMinutes + "m");
        }
        return new ComplexIssueInputFieldValue(fields);
    }
}

