/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class JtaTransactionManagerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String WEBLOGIC_JTA_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.WebLogicJtaTransactionManager";
    private static final String WEBSPHERE_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.WebSphereUowTransactionManager";
    private static final String JTA_TRANSACTION_MANAGER_CLASS_NAME = "org.springframework.transaction.jta.JtaTransactionManager";
    private static final boolean weblogicPresent = ClassUtils.isPresent("weblogic.transaction.UserTransaction", JtaTransactionManagerBeanDefinitionParser.class.getClassLoader());
    private static final boolean webspherePresent = ClassUtils.isPresent("com.ibm.wsspi.uow.UOWManager", JtaTransactionManagerBeanDefinitionParser.class.getClassLoader());

    @Override
    protected String getBeanClassName(Element element) {
        if (weblogicPresent) {
            return WEBLOGIC_JTA_TRANSACTION_MANAGER_CLASS_NAME;
        }
        if (webspherePresent) {
            return WEBSPHERE_TRANSACTION_MANAGER_CLASS_NAME;
        }
        return JTA_TRANSACTION_MANAGER_CLASS_NAME;
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return "transactionManager";
    }
}

