/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractJaxWsServiceExporter
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private Map<String, Object> endpointProperties;
    private Executor executor;
    private String bindingType;
    private WebServiceFeature[] endpointFeatures;
    private Object[] webServiceFeatures;
    private ListableBeanFactory beanFactory;
    private final Set<Endpoint> publishedEndpoints = new LinkedHashSet<Endpoint>();

    public void setEndpointProperties(Map<String, Object> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setBindingType(String bindingType) {
        this.bindingType = bindingType;
    }

    public void setEndpointFeatures(WebServiceFeature ... endpointFeatures) {
        this.endpointFeatures = endpointFeatures;
    }

    @Deprecated
    public void setWebServiceFeatures(Object[] webServiceFeatures) {
        this.webServiceFeatures = webServiceFeatures;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " requires a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.publishEndpoints();
    }

    public void publishEndpoints() {
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>(this.beanFactory.getBeanDefinitionCount());
        beanNames.addAll(Arrays.asList(this.beanFactory.getBeanDefinitionNames()));
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            beanNames.addAll(Arrays.asList(((ConfigurableBeanFactory)((Object)this.beanFactory)).getSingletonNames()));
        }
        for (String beanName : beanNames) {
            try {
                Class<?> type = this.beanFactory.getType(beanName);
                if (type == null || type.isInterface()) continue;
                WebService wsAnnotation = type.getAnnotation(WebService.class);
                WebServiceProvider wsProviderAnnotation = type.getAnnotation(WebServiceProvider.class);
                if (wsAnnotation == null && wsProviderAnnotation == null) continue;
                Endpoint endpoint = this.createEndpoint(this.beanFactory.getBean(beanName));
                if (this.endpointProperties != null) {
                    endpoint.setProperties(this.endpointProperties);
                }
                if (this.executor != null) {
                    endpoint.setExecutor(this.executor);
                }
                if (wsAnnotation != null) {
                    this.publishEndpoint(endpoint, wsAnnotation);
                } else {
                    this.publishEndpoint(endpoint, wsProviderAnnotation);
                }
                this.publishedEndpoints.add(endpoint);
            }
            catch (CannotLoadBeanClassException ex) {}
        }
    }

    protected Endpoint createEndpoint(Object bean) {
        if (this.endpointFeatures != null || this.webServiceFeatures != null) {
            WebServiceFeature[] endpointFeaturesToUse = this.endpointFeatures;
            if (endpointFeaturesToUse == null) {
                endpointFeaturesToUse = new WebServiceFeature[this.webServiceFeatures.length];
                for (int i = 0; i < this.webServiceFeatures.length; ++i) {
                    endpointFeaturesToUse[i] = this.convertWebServiceFeature(this.webServiceFeatures[i]);
                }
            }
            return Endpoint.create((String)this.bindingType, (Object)bean, (WebServiceFeature[])endpointFeaturesToUse);
        }
        return Endpoint.create((String)this.bindingType, (Object)bean);
    }

    private WebServiceFeature convertWebServiceFeature(Object feature) {
        Assert.notNull(feature, "WebServiceFeature specification object must not be null");
        if (feature instanceof WebServiceFeature) {
            return (WebServiceFeature)feature;
        }
        if (feature instanceof Class) {
            return (WebServiceFeature)BeanUtils.instantiate((Class)feature);
        }
        if (feature instanceof String) {
            try {
                Class<?> featureClass = this.getBeanClassLoader().loadClass((String)feature);
                return (WebServiceFeature)BeanUtils.instantiate(featureClass);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Could not load WebServiceFeature class [" + feature + "]");
            }
        }
        throw new IllegalArgumentException("Unknown WebServiceFeature specification type: " + feature.getClass());
    }

    private ClassLoader getBeanClassLoader() {
        return this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)((Object)this.beanFactory)).getBeanClassLoader() : ClassUtils.getDefaultClassLoader();
    }

    protected abstract void publishEndpoint(Endpoint var1, WebService var2);

    protected abstract void publishEndpoint(Endpoint var1, WebServiceProvider var2);

    @Override
    public void destroy() {
        for (Endpoint endpoint : this.publishedEndpoints) {
            endpoint.stop();
        }
    }
}

