/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class OpenSessionInterceptor
implements MethodInterceptor,
InitializingBean {
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        SessionFactory sf = this.getSessionFactory();
        if (!TransactionSynchronizationManager.hasResource(sf)) {
            org.hibernate.Session session = this.openSession();
            try {
                TransactionSynchronizationManager.bindResource(sf, new SessionHolder(session));
                Object object = invocation.proceed();
                return object;
            }
            finally {
                SessionFactoryUtils.closeSession(session);
                TransactionSynchronizationManager.unbindResource(sf);
            }
        }
        return invocation.proceed();
    }

    protected org.hibernate.Session openSession() throws DataAccessResourceFailureException {
        try {
            Session session = this.getSessionFactory().openSession();
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }
}

