/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.util.Properties;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Transaction;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JDBCTransaction;
import org.hibernate.transaction.TransactionFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionFactory
implements TransactionFactory {
    @Override
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.ON_CLOSE;
    }

    @Override
    public Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        return new JDBCTransaction(jdbcContext, transactionContext);
    }

    @Override
    public void configure(Properties props) {
    }

    @Override
    public boolean isTransactionManagerRequired() {
        return false;
    }

    @Override
    public boolean areCallbacksLocalToHibernateTransactions() {
        return true;
    }

    @Override
    public boolean isTransactionInProgress(JDBCContext jdbcContext, TransactionFactory.Context transactionContext, Transaction transaction) {
        return transaction != null && transaction.isActive() || TransactionSynchronizationManager.isActualTransactionActive();
    }
}

