/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class JmsResourceHolder
extends ResourceHolderSupport {
    private static final Log logger = LogFactory.getLog(JmsResourceHolder.class);
    private ConnectionFactory connectionFactory;
    private boolean frozen = false;
    private final List<Connection> connections = new LinkedList<Connection>();
    private final List<Session> sessions = new LinkedList<Session>();
    private final Map<Connection, List<Session>> sessionsPerConnection = new HashMap<Connection, List<Session>>();

    public JmsResourceHolder() {
    }

    public JmsResourceHolder(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsResourceHolder(Session session) {
        this.addSession(session);
        this.frozen = true;
    }

    public JmsResourceHolder(Connection connection, Session session) {
        this.addConnection(connection);
        this.addSession(session, connection);
        this.frozen = true;
    }

    public JmsResourceHolder(ConnectionFactory connectionFactory, Connection connection, Session session) {
        this.connectionFactory = connectionFactory;
        this.addConnection(connection);
        this.addSession(session, connection);
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void addConnection(Connection connection) {
        Assert.isTrue(!this.frozen, "Cannot add Connection because JmsResourceHolder is frozen");
        Assert.notNull(connection, "Connection must not be null");
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public final void addSession(Session session) {
        this.addSession(session, null);
    }

    public final void addSession(Session session, Connection connection) {
        Assert.isTrue(!this.frozen, "Cannot add Session because JmsResourceHolder is frozen");
        Assert.notNull(session, "Session must not be null");
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            if (connection != null) {
                List<Session> sessions = this.sessionsPerConnection.get(connection);
                if (sessions == null) {
                    sessions = new LinkedList<Session>();
                    this.sessionsPerConnection.put(connection, sessions);
                }
                sessions.add(session);
            }
        }
    }

    public boolean containsSession(Session session) {
        return this.sessions.contains(session);
    }

    public Connection getConnection() {
        return !this.connections.isEmpty() ? this.connections.get(0) : null;
    }

    public Connection getConnection(Class<? extends Connection> connectionType) {
        return CollectionUtils.findValueOfType(this.connections, connectionType);
    }

    public Session getSession() {
        return !this.sessions.isEmpty() ? this.sessions.get(0) : null;
    }

    public Session getSession(Class<? extends Session> sessionType) {
        return this.getSession(sessionType, null);
    }

    public Session getSession(Class<? extends Session> sessionType, Connection connection) {
        List<Session> sessions = this.sessions;
        if (connection != null) {
            sessions = this.sessionsPerConnection.get(connection);
        }
        return CollectionUtils.findValueOfType(sessions, sessionType);
    }

    public void commitAll() throws JMSException {
        for (Session session : this.sessions) {
            try {
                session.commit();
            }
            catch (TransactionInProgressException ex) {
            }
            catch (IllegalStateException ex) {
                block11: {
                    if (this.connectionFactory != null) {
                        try {
                            Method getDataSourceMethod = this.connectionFactory.getClass().getMethod("getDataSource", new Class[0]);
                            Object ds = ReflectionUtils.invokeMethod(getDataSourceMethod, this.connectionFactory);
                            while (ds != null) {
                                if (TransactionSynchronizationManager.hasResource(ds)) {
                                    return;
                                }
                                try {
                                    Method getTargetDataSourceMethod = ds.getClass().getMethod("getTargetDataSource", new Class[0]);
                                    ds = ReflectionUtils.invokeMethod(getTargetDataSourceMethod, ds);
                                }
                                catch (NoSuchMethodException nsme) {
                                    ds = null;
                                }
                            }
                        }
                        catch (Throwable ex2) {
                            if (!logger.isDebugEnabled()) break block11;
                            logger.debug("No working getDataSource method found on ConnectionFactory: " + ex2);
                        }
                    }
                }
                throw ex;
            }
        }
    }

    public void closeAll() {
        for (Session session : this.sessions) {
            try {
                session.close();
            }
            catch (Throwable ex) {
                logger.debug("Could not close synchronized JMS Session after transaction", ex);
            }
        }
        for (Connection con : this.connections) {
            ConnectionFactoryUtils.releaseConnection(con, this.connectionFactory, true);
        }
        this.connections.clear();
        this.sessions.clear();
        this.sessionsPerConnection.clear();
    }
}

