/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.object.SqlQuery;
import org.springframework.util.Assert;

public class GenericSqlQuery<T>
extends SqlQuery<T> {
    Class<?> rowMapperClass;
    RowMapper<?> rowMapper;

    public void setRowMapperClass(Class<? extends RowMapper> rowMapperClass) throws IllegalAccessException, InstantiationException {
        this.rowMapperClass = rowMapperClass;
        if (!RowMapper.class.isAssignableFrom(rowMapperClass)) {
            throw new IllegalStateException("The specified class '" + rowMapperClass.getName() + " is not a sub class of " + "'org.springframework.jdbc.core.RowMapper'");
        }
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull(this.rowMapperClass, "The 'rowMapperClass' property is required");
    }

    @Override
    protected RowMapper<T> newRowMapper(Object[] parameters, Map<?, ?> context) {
        try {
            return (RowMapper)this.rowMapperClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidDataAccessResourceUsageException("Unable to instantiate RowMapper", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidDataAccessResourceUsageException("Unable to instantiate RowMapper", e);
        }
    }
}

