/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

@Deprecated
public class JacksonObjectMapperFactoryBean
implements FactoryBean<ObjectMapper>,
InitializingBean {
    private ObjectMapper objectMapper;
    private Map<Object, Boolean> features = new HashMap<Object, Boolean>();
    private DateFormat dateFormat;
    private AnnotationIntrospector annotationIntrospector;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSimpleDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public void setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.annotationIntrospector = annotationIntrospector;
    }

    public void setAutoDetectFields(boolean autoDetectFields) {
        this.features.put(SerializationConfig.Feature.AUTO_DETECT_FIELDS, autoDetectFields);
        this.features.put(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, autoDetectFields);
    }

    public void setAutoDetectGettersSetters(boolean autoDetectGettersSetters) {
        this.features.put(SerializationConfig.Feature.AUTO_DETECT_GETTERS, autoDetectGettersSetters);
        this.features.put(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, autoDetectGettersSetters);
    }

    public void setFailOnEmptyBeans(boolean failOnEmptyBeans) {
        this.features.put(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, failOnEmptyBeans);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.features.put(SerializationConfig.Feature.INDENT_OUTPUT, indentOutput);
    }

    public void setFeaturesToEnable(Object[] featuresToEnable) {
        if (featuresToEnable != null) {
            for (Object feature : featuresToEnable) {
                this.features.put(feature, Boolean.TRUE);
            }
        }
    }

    public void setFeaturesToDisable(Object[] featuresToDisable) {
        if (featuresToDisable != null) {
            for (Object feature : featuresToDisable) {
                this.features.put(feature, Boolean.FALSE);
            }
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        if (this.annotationIntrospector != null) {
            this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().withAnnotationIntrospector(this.annotationIntrospector));
            this.objectMapper.setDeserializationConfig(this.objectMapper.getDeserializationConfig().withAnnotationIntrospector(this.annotationIntrospector));
        }
        if (this.dateFormat != null) {
            this.objectMapper.setDateFormat(this.dateFormat);
        }
        for (Map.Entry<Object, Boolean> entry : this.features.entrySet()) {
            this.configureFeature(entry.getKey(), entry.getValue());
        }
    }

    private void configureFeature(Object feature, boolean enabled) {
        if (feature instanceof JsonParser.Feature) {
            this.objectMapper.configure((JsonParser.Feature)((Object)feature), enabled);
        } else if (feature instanceof JsonGenerator.Feature) {
            this.objectMapper.configure((JsonGenerator.Feature)((Object)feature), enabled);
        } else if (feature instanceof SerializationConfig.Feature) {
            this.objectMapper.configure((SerializationConfig.Feature)feature, enabled);
        } else if (feature instanceof DeserializationConfig.Feature) {
            this.objectMapper.configure((DeserializationConfig.Feature)feature, enabled);
        } else {
            throw new IllegalArgumentException("Unknown feature class: " + feature.getClass().getName());
        }
    }

    @Override
    public ObjectMapper getObject() {
        return this.objectMapper;
    }

    @Override
    public Class<?> getObjectType() {
        return ObjectMapper.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

