/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache;

import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpMethodExecutor;
import com.sun.jersey.client.apache.DefaultApacheHttpMethodExecutor;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.util.ReaderWriter;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.ws.rs.core.Context;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public final class ApacheHttpClientHandler
implements ClientHandler {
    private final HttpClient client;
    private final ClientConfig config;
    private final ApacheHttpMethodExecutor methodExecutor;
    @Context
    private MessageBodyWorkers workers;

    public ApacheHttpClientHandler(HttpClient client) {
        this(client, new DefaultApacheHttpClientConfig(), new DefaultApacheHttpMethodExecutor(client));
    }

    public ApacheHttpClientHandler(HttpClient client, ClientConfig config) {
        this(client, config, new DefaultApacheHttpMethodExecutor(client));
    }

    public ApacheHttpClientHandler(HttpClient client, ClientConfig config, ApacheHttpMethodExecutor methodExecutor) {
        this.client = client;
        this.config = config;
        client.getParams().setAuthenticationPreemptive(config.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication"));
        Integer connectTimeout = (Integer)config.getProperty("com.sun.jersey.client.property.connectTimeout");
        if (connectTimeout != null) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeout);
        }
        this.methodExecutor = methodExecutor;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        HttpMethod method = this.getHttpMethod(cr);
        this.methodExecutor.executeMethod(method, cr);
        try {
            ClientResponse r = new ClientResponse(method.getStatusCode(), this.getInBoundHeaders(method), new HttpClientResponseInputStream(method), this.workers);
            if (!r.hasEntity()) {
                r.bufferEntity();
                r.close();
            }
            return r;
        }
        catch (Exception e) {
            method.releaseConnection();
            throw new ClientHandlerException(e);
        }
    }

    private HttpMethod getHttpMethod(ClientRequest cr) {
        String strMethod = cr.getMethod();
        String uri = cr.getURI().toString();
        if (strMethod.equals("GET")) {
            return new GetMethod(uri);
        }
        if (strMethod.equals("POST")) {
            return new PostMethod(uri);
        }
        if (strMethod.equals("PUT")) {
            return new PutMethod(uri);
        }
        if (strMethod.equals("DELETE")) {
            return new CustomMethod("DELETE", uri);
        }
        if (strMethod.equals("HEAD")) {
            return new HeadMethod(uri);
        }
        if (strMethod.equals("OPTIONS")) {
            return new OptionsMethod(uri);
        }
        return new CustomMethod(strMethod, uri);
    }

    private InBoundHeaders getInBoundHeaders(HttpMethod method) {
        Header[] respHeaders;
        InBoundHeaders headers = new InBoundHeaders();
        for (Header header : respHeaders = method.getResponseHeaders()) {
            ArrayList<String> list = (ArrayList<String>)headers.get(header.getName());
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(header.getValue());
            headers.put(header.getName(), list);
        }
        return headers;
    }

    private static InputStream getInputStream(HttpMethod method) throws IOException {
        InputStream i = method.getResponseBodyAsStream();
        if (i == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (i.markSupported()) {
            return i;
        }
        return new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE);
    }

    ApacheHttpMethodExecutor getMethodProcessor() {
        return this.methodExecutor;
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        private final HttpMethod method;

        HttpClientResponseInputStream(HttpMethod method) throws IOException {
            super(ApacheHttpClientHandler.getInputStream(method));
            this.method = method;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.method.releaseConnection();
        }
    }

    private static class CustomMethod
    extends EntityEnclosingMethod {
        private String method;

        CustomMethod(String method, String uri) {
            super(uri);
            this.method = method;
        }

        @Override
        public String getName() {
            return this.method;
        }
    }
}

