/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ComponentRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.domain.Component;
import com.atlassian.jira.rest.client.domain.input.ComponentInput;
import com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.ComponentJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.gen.ComponentInputWithProjectKeyJsonGenerator;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JerseyComponentRestClient
extends AbstractJerseyRestClient
implements ComponentRestClient {
    private final ComponentJsonParser componentJsonParser = new ComponentJsonParser();
    private final URI componentUri;

    public JerseyComponentRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
        this.componentUri = UriBuilder.fromUri(baseUri).path("component").build(new Object[0]);
    }

    @Override
    public Component getComponent(URI componentUri, ProgressMonitor progressMonitor) {
        return this.getAndParse(componentUri, this.componentJsonParser, progressMonitor);
    }

    @Override
    public Component createComponent(String projectKey, ComponentInput componentInput, ProgressMonitor progressMonitor) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(projectKey, componentInput);
        return this.postAndParse(this.componentUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new ComponentInputWithProjectKeyJsonGenerator(), helper), new ComponentJsonParser(), progressMonitor);
    }

    @Override
    public Component updateComponent(URI componentUri, ComponentInput componentInput, ProgressMonitor progressMonitor) {
        ComponentInputWithProjectKey helper = new ComponentInputWithProjectKey(null, componentInput);
        return this.putAndParse(componentUri, AbstractJerseyRestClient.InputGeneratorCallable.create(new ComponentInputWithProjectKeyJsonGenerator(), helper), new ComponentJsonParser(), progressMonitor);
    }

    @Override
    public void removeComponent(URI componentUri, @Nullable URI moveIssueToComponentUri, ProgressMonitor progressMonitor) {
        UriBuilder uriBuilder = UriBuilder.fromUri(componentUri);
        if (moveIssueToComponentUri != null) {
            uriBuilder.queryParam("moveIssuesTo", moveIssueToComponentUri);
        }
        this.delete(uriBuilder.build(new Object[0]), progressMonitor);
    }

    @Override
    public int getComponentRelatedIssuesCount(URI componentUri, ProgressMonitor progressMonitor) {
        URI relatedIssueCountsUri = UriBuilder.fromUri(componentUri).path("relatedIssueCounts").build(new Object[0]);
        return this.getAndParse(relatedIssueCountsUri, new JsonObjectParser<Integer>(){

            @Override
            public Integer parse(JSONObject json) throws JSONException {
                return json.getInt("issueCount");
            }
        }, progressMonitor);
    }
}

