/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.google.common.base.Strings;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.netmgt.ticketer.jira.Config;
import org.opennms.netmgt.ticketer.jira.JiraConnectionFactory;
import org.opennms.netmgt.ticketer.jira.JiraTicketerPlugin;

public abstract class AbstractJiraCommand
extends OsgiCommandSupport {
    protected static final String LINE = "------------------------------";
    protected static final String DEFAULT_ROW_FORMAT = "%-10.10s %-30.30s %-100.100s";
    @Option(name="-h", aliases={"--host"}, description="The jira host to use. If defined it overrides the default defined in the jira ticketer plugin configuration.")
    public String host;
    @Option(name="-u", aliases={"--username"}, description="The user to connect to jira. If defined it overrides the default defined in the jira ticketer plugin configuration.")
    public String username;
    @Option(name="-p", aliases={"--password"}, description="The password to use to connect to jira. If defined it overrides the default defined in the jira ticketer plugin configuration.")
    public String password;
    @Option(name="-a", aliases={"--anonymous"}, description="Defines that no authentication is used. Cannot be used with <username> and <password> alltogether")
    public boolean noAuthentication;

    protected JiraRestClient createJiraClient() throws PluginException {
        String thePassword;
        Config config = this.getConfig();
        String theHost = Strings.isNullOrEmpty((String)this.host) ? config.getHost() : this.host;
        String theUser = Strings.isNullOrEmpty((String)this.username) ? config.getUsername() : this.username;
        String string = thePassword = Strings.isNullOrEmpty((String)this.password) ? config.getPassword() : this.password;
        if (this.noAuthentication) {
            return JiraConnectionFactory.createConnection(theHost, null, null);
        }
        return JiraConnectionFactory.createConnection(theHost, theUser, thePassword);
    }

    protected Object doExecute() throws Exception {
        try (JiraRestClient jiraClient = this.createJiraClient();){
            this.doExecute(jiraClient);
        }
        return null;
    }

    protected Config getConfig() {
        return JiraTicketerPlugin.getConfig();
    }

    protected abstract void doExecute(JiraRestClient var1) throws Exception;

    protected static String removeNewLines(String input) {
        return input.replaceAll(System.getProperty("line.separator"), "");
    }
}

