/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractTransitionableStateModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class ViewStateModel
extends AbstractTransitionableStateModel {
    private String view;
    private String redirect;
    private String popup;
    private String model;
    private LinkedList vars;
    private BinderModel binder;
    private LinkedList onRenderActions;

    public ViewStateModel(String id) {
        super(id);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof ViewStateModel)) {
            return false;
        }
        ViewStateModel state = (ViewStateModel)model;
        return ObjectUtils.nullSafeEquals(this.getId(), state.getId());
    }

    public void merge(Model model) {
        ViewStateModel state = (ViewStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setTransitions(this.merge(this.getTransitions(), state.getTransitions()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
        this.setView(this.merge(this.getView(), state.getView()));
        this.setRedirect(this.merge(this.getRedirect(), state.getRedirect()));
        this.setPopup(this.merge(this.getPopup(), state.getPopup()));
        this.setModel(this.merge(this.getModel(), state.getModel()));
        this.setVars(this.merge(this.getVars(), state.getVars(), false));
        this.setBinder((BinderModel)this.merge(this.getBinder(), state.getBinder()));
        this.setOnRenderActions(this.merge(this.getOnRenderActions(), state.getOnRenderActions(), false));
    }

    public Model createCopy() {
        ViewStateModel copy = new ViewStateModel(this.getId());
        super.fillCopy(copy);
        copy.setView(this.view);
        copy.setRedirect(this.redirect);
        copy.setPopup(this.popup);
        copy.setModel(this.model);
        copy.setVars(this.copyList(this.vars));
        copy.setBinder((BinderModel)this.copy(this.binder));
        copy.setOnRenderActions(this.copyList(this.onRenderActions));
        return copy;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = StringUtils.hasText(view) ? view : null;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = StringUtils.hasText(redirect) ? redirect : null;
    }

    public String getPopup() {
        return this.popup;
    }

    public void setPopup(String popup) {
        this.popup = StringUtils.hasText(popup) ? popup : null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = StringUtils.hasText(model) ? model : null;
    }

    public LinkedList getVars() {
        return this.vars;
    }

    public void setVars(LinkedList vars) {
        this.vars = vars;
    }

    public BinderModel getBinder() {
        return this.binder;
    }

    public void setBinder(BinderModel binder) {
        this.binder = binder;
    }

    public LinkedList getOnRenderActions() {
        return this.onRenderActions;
    }

    public void setOnRenderActions(LinkedList onRenderActions) {
        this.onRenderActions = onRenderActions;
    }
}

