/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.support.FluentParserContext;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.support.DefaultTargetStateResolver;
import org.springframework.webflow.execution.RequestContext;

class TextToTargetStateResolver
implements Converter {
    private FlowBuilderContext flowBuilderContext;

    public TextToTargetStateResolver(FlowBuilderContext flowBuilderContext) {
        this.flowBuilderContext = flowBuilderContext;
    }

    public Class getSourceClass() {
        return String.class;
    }

    public Class getTargetClass() {
        return TargetStateResolver.class;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        String targetStateId = (String)source;
        if (!StringUtils.hasText(targetStateId)) {
            return null;
        }
        ExpressionParser parser = this.flowBuilderContext.getExpressionParser();
        Expression expression = parser.parseExpression(targetStateId, new FluentParserContext().template().evaluate(RequestContext.class).expectResult(String.class));
        return new DefaultTargetStateResolver(expression);
    }
}

