/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.mapping.Mapper;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.DecisionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.SubflowAttributeMapper;
import org.springframework.webflow.engine.SubflowState;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.ViewVariable;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ViewFactory;

public class FlowArtifactFactory {
    public Flow createFlow(String id, AttributeMap attributes) {
        return Flow.create(id, attributes);
    }

    public State createViewState(String id, Flow flow, ViewVariable[] variables, Action[] entryActions, ViewFactory viewFactory, Boolean redirect, boolean popup, Action[] renderActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        ViewState viewState = new ViewState(flow, id, viewFactory);
        viewState.addVariables(variables);
        viewState.setRedirect(redirect);
        viewState.setPopup(popup);
        viewState.getRenderActionList().addAll(renderActions);
        this.configureCommonProperties(viewState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return viewState;
    }

    public State createActionState(String id, Flow flow, Action[] entryActions, Action[] actions2, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        ActionState actionState = new ActionState(flow, id);
        actionState.getActionList().addAll(actions2);
        this.configureCommonProperties(actionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return actionState;
    }

    public State createDecisionState(String id, Flow flow, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        DecisionState decisionState = new DecisionState(flow, id);
        this.configureCommonProperties(decisionState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return decisionState;
    }

    public State createSubflowState(String id, Flow flow, Action[] entryActions, Expression subflow, SubflowAttributeMapper attributeMapper, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        SubflowState subflowState = new SubflowState(flow, id, subflow);
        if (attributeMapper != null) {
            subflowState.setAttributeMapper(attributeMapper);
        }
        this.configureCommonProperties(subflowState, entryActions, transitions, exceptionHandlers, exitActions, attributes);
        return subflowState;
    }

    public State createEndState(String id, Flow flow, Action[] entryActions, Action finalResponseAction, Mapper outputMapper, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        EndState endState = new EndState(flow, id);
        if (finalResponseAction != null) {
            endState.setFinalResponseAction(finalResponseAction);
        }
        if (outputMapper != null) {
            endState.setOutputMapper(outputMapper);
        }
        this.configureCommonProperties(endState, entryActions, exceptionHandlers, attributes);
        return endState;
    }

    public Transition createTransition(TargetStateResolver targetStateResolver, TransitionCriteria matchingCriteria, TransitionCriteria executionCriteria, AttributeMap attributes) {
        Transition transition = new Transition(targetStateResolver);
        if (matchingCriteria != null) {
            transition.setMatchingCriteria(matchingCriteria);
        }
        if (executionCriteria != null) {
            transition.setExecutionCriteria(executionCriteria);
        }
        transition.getAttributes().putAll(attributes);
        return transition;
    }

    private void configureCommonProperties(TransitionableState state, Action[] entryActions, Transition[] transitions, FlowExecutionExceptionHandler[] exceptionHandlers, Action[] exitActions, AttributeMap attributes) {
        this.configureCommonProperties(state, entryActions, exceptionHandlers, attributes);
        state.getTransitionSet().addAll(transitions);
        state.getExitActionList().addAll(exitActions);
    }

    private void configureCommonProperties(State state, Action[] entryActions, FlowExecutionExceptionHandler[] exceptionHandlers, AttributeMap attributes) {
        state.getEntryActionList().addAll(entryActions);
        state.getExceptionHandlerSet().addAll(exceptionHandlers);
        state.getAttributes().putAll(attributes);
    }
}

