/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.definition.registry.StaticFlowDefinitionHolder;

public class FlowDefinitionRegistryImpl
implements FlowDefinitionRegistry {
    private static final Log logger = LogFactory.getLog(FlowDefinitionRegistryImpl.class);
    private Map flowDefinitions = new TreeMap();
    private FlowDefinitionRegistry parent;

    public FlowDefinition getFlowDefinition(String id) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        Assert.hasText(id, "An id is required to lookup a FlowDefinition");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting FlowDefinition with id '" + id + "'");
            }
            return this.getFlowDefinitionHolder(id).getFlowDefinition();
        }
        catch (NoSuchFlowDefinitionException e) {
            if (this.parent != null) {
                return this.parent.getFlowDefinition(id);
            }
            throw e;
        }
    }

    public boolean containsFlowDefinition(String flowId) {
        boolean containsFlow = this.flowDefinitions.containsKey(flowId);
        if (!containsFlow && this.parent != null) {
            containsFlow = this.parent.containsFlowDefinition(flowId);
        }
        return containsFlow;
    }

    public int getFlowDefinitionCount() {
        return this.flowDefinitions.size();
    }

    public String[] getFlowDefinitionIds() {
        return this.flowDefinitions.keySet().toArray(new String[this.flowDefinitions.size()]);
    }

    public FlowDefinitionRegistry getParent() {
        return this.parent;
    }

    public void setParent(FlowDefinitionRegistry parent) {
        this.parent = parent;
    }

    public void registerFlowDefinition(FlowDefinitionHolder definitionHolder) {
        Assert.notNull(definitionHolder, "The holder of the flow definition to register is required");
        if (logger.isDebugEnabled()) {
            logger.debug("Registering flow definition '" + definitionHolder.getFlowDefinitionResourceString() + "' under id '" + definitionHolder.getFlowDefinitionId() + "'");
        }
        this.flowDefinitions.put(definitionHolder.getFlowDefinitionId(), definitionHolder);
    }

    public void registerFlowDefinition(FlowDefinition definition) {
        this.registerFlowDefinition(new StaticFlowDefinitionHolder(definition));
    }

    public void destroy() {
        for (FlowDefinitionHolder holder : this.flowDefinitions.values()) {
            holder.destroy();
        }
    }

    private FlowDefinitionHolder getFlowDefinitionHolder(String id) throws NoSuchFlowDefinitionException {
        FlowDefinitionHolder holder = (FlowDefinitionHolder)this.flowDefinitions.get(id);
        if (holder == null) {
            throw new NoSuchFlowDefinitionException(id);
        }
        return holder;
    }

    public String toString() {
        return new ToStringCreator(this).append("flowIds", this.getFlowDefinitionIds()).append("parent", this.parent).toString();
    }
}

