/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.core.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.binding.collection.MapAccessor;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;

public class LocalAttributeMap
implements MutableAttributeMap,
Serializable {
    private Map attributes;
    private transient MapAccessor attributeAccessor;

    public LocalAttributeMap() {
        this.initAttributes(this.createTargetMap());
    }

    public LocalAttributeMap(int size, int loadFactor) {
        this.initAttributes(this.createTargetMap(size, loadFactor));
    }

    public LocalAttributeMap(String attributeName, Object attributeValue) {
        this.initAttributes(this.createTargetMap(1, 1));
        this.put(attributeName, attributeValue);
    }

    public LocalAttributeMap(Map map) {
        Assert.notNull(map, "The target map is required");
        this.initAttributes(map);
    }

    public Map asMap() {
        return this.attributeAccessor.asMap();
    }

    public int size() {
        return this.attributes.size();
    }

    public Object get(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean contains(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public boolean contains(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.containsKey(attributeName, requiredType);
    }

    public Object get(String attributeName, Object defaultValue) {
        return this.attributeAccessor.get((Object)attributeName, defaultValue);
    }

    public Object get(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.get((Object)attributeName, requiredType);
    }

    public Object get(String attributeName, Class requiredType, Object defaultValue) throws IllegalStateException {
        return this.attributeAccessor.get(attributeName, requiredType, defaultValue);
    }

    public Object getRequired(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired(attributeName);
    }

    public Object getRequired(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequired(attributeName, requiredType);
    }

    public String getString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getString(attributeName);
    }

    public String getString(String attributeName, String defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getString(attributeName, defaultValue);
    }

    public String getRequiredString(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredString(attributeName);
    }

    public Collection getCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection(attributeName);
    }

    public Collection getCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getCollection(attributeName, requiredType);
    }

    public Collection getRequiredCollection(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection(attributeName);
    }

    public Collection getRequiredCollection(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredCollection(attributeName, requiredType);
    }

    public Object[] getArray(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getArray(attributeName, requiredType);
    }

    public Object[] getRequiredArray(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredArray(attributeName, requiredType);
    }

    public Number getNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber(attributeName, requiredType);
    }

    public Number getNumber(String attributeName, Class requiredType, Number defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getNumber(attributeName, requiredType, defaultValue);
    }

    public Number getRequiredNumber(String attributeName, Class requiredType) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredNumber(attributeName, requiredType);
    }

    public Integer getInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger(attributeName);
    }

    public Integer getInteger(String attributeName, Integer defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getInteger(attributeName, defaultValue);
    }

    public Integer getRequiredInteger(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredInteger(attributeName);
    }

    public Long getLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getLong(attributeName);
    }

    public Long getLong(String attributeName, Long defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getLong(attributeName, defaultValue);
    }

    public Long getRequiredLong(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredLong(attributeName);
    }

    public Boolean getBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean(attributeName);
    }

    public Boolean getBoolean(String attributeName, Boolean defaultValue) throws IllegalArgumentException {
        return this.attributeAccessor.getBoolean(attributeName, defaultValue);
    }

    public Boolean getRequiredBoolean(String attributeName) throws IllegalArgumentException {
        return this.attributeAccessor.getRequiredBoolean(attributeName);
    }

    public AttributeMap union(AttributeMap attributes) {
        if (attributes == null) {
            return new LocalAttributeMap(this.getMapInternal());
        }
        Map map = this.createTargetMap();
        map.putAll(this.getMapInternal());
        map.putAll(attributes.asMap());
        return new LocalAttributeMap(map);
    }

    public Object put(String attributeName, Object attributeValue) {
        return this.getMapInternal().put(attributeName, attributeValue);
    }

    public MutableAttributeMap putAll(AttributeMap attributes) {
        if (attributes == null) {
            return this;
        }
        this.getMapInternal().putAll(attributes.asMap());
        return this;
    }

    public MutableAttributeMap removeAll(MutableAttributeMap attributes) {
        if (attributes == null) {
            return this;
        }
        Iterator it = attributes.asMap().keySet().iterator();
        Map internal = this.getMapInternal();
        while (it.hasNext()) {
            internal.remove(it.next());
        }
        return this;
    }

    public Object remove(String attributeName) {
        return this.getMapInternal().remove(attributeName);
    }

    public Object extract(String attributeName) {
        Map map = this.getMapInternal();
        if (map.containsKey(attributeName)) {
            Object value = map.get(attributeName);
            map.remove(attributeName);
            return value;
        }
        return null;
    }

    public MutableAttributeMap clear() throws UnsupportedOperationException {
        this.getMapInternal().clear();
        return this;
    }

    public MutableAttributeMap replaceWith(AttributeMap attributes) throws UnsupportedOperationException {
        this.clear();
        this.putAll(attributes);
        return this;
    }

    protected void initAttributes(Map attributes) {
        this.attributes = attributes;
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    protected Map getMapInternal() {
        return this.attributes;
    }

    protected Map createTargetMap() {
        return new HashMap();
    }

    protected Map createTargetMap(int size, int loadFactor) {
        return new HashMap(size, loadFactor);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalAttributeMap)) {
            return false;
        }
        LocalAttributeMap other = (LocalAttributeMap)o;
        return this.getMapInternal().equals(other.getMapInternal());
    }

    public int hashCode() {
        return this.getMapInternal().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attributeAccessor = new MapAccessor(this.attributes);
    }

    public String toString() {
        return StylerUtils.style(this.attributes);
    }
}

